#!/usr/bin/env perl

use strict;
use utf8;
binmode STDIN, ":encoding(utf8)";
binmode STDERR, ":encoding(utf8)";
binmode STDOUT, ":encoding(utf8)";

if ( @ARGV != 2 ) {
    print STDERR "$0 <normalization rule1> <normalization rule2>\n";
    exit;
}
my %rule1_;
my %rule2_;
&read_rule1( $ARGV[0] );
&read_rule2( $ARGV[1] );
&main();


sub read_rule1 {

    my ( $filename ) = @_;
    
    open( TEXT, $filename ) or die print STDERR "$filename\n";
    binmode( TEXT, ":encoding(utf8)" );
    while ( <TEXT> ) {
	chomp;
	if ( /^$/ || /^\#/ ) {
	    next;
	}else {
	    my ( $surface_form, $surface_pos, $normal_form, $normal_reading, $normal_pos, $citation_form ) = split( /\s+/, $_ );
	    @{$rule1_{$surface_form}{$surface_pos}} = ( $normal_form, $normal_reading, $normal_pos, $citation_form );
	}
    }
    close( TEXT );
}


sub read_rule2 {

    my ( $filename ) = @_;
    
    open( TEXT, $filename ) or die print STDERR "$filename\n";
    binmode( TEXT, ":encoding(utf8)" );
    while ( <TEXT> ) {
	chomp;
	if ( /^$/ || /^\#/ ) {
	    next;
	}else {
	    my ( $ctype, $cform, $suffix, $normal_cform, $normal_suffix ) = split( /\s+/, $_ );
	    push( @{$rule2_{$ctype}{$cform}},  { suffix => $suffix, normal_cform => $normal_cform, normal_suffix => $normal_suffix } );
	}
    }
    close( TEXT );
}


sub main {

    my %dict;
    while ( <STDIN> ) {
	chomp;
	my ( $surface_form, $surface_pos, $normal_form, $normal_reading, $normal_pos, $citation_form ) = split( /\t/, $_ );
	if ( $surface_form ne $normal_form || $surface_pos ne $normal_pos ) {
	    print "Error: $_\n";
	}
	my ( $new_normal_form, $new_normal_reading, $new_normal_pos, $new_citation_form ) = &rewrite( $surface_form, $surface_pos, $normal_form, $normal_reading, $normal_pos, $citation_form );
	push( @{$dict{"$new_normal_form\t$new_normal_reading\t$new_normal_pos\t$new_citation_form"}{"surface_form"}}, $surface_form );
	push( @{$dict{"$new_normal_form\t$new_normal_reading\t$new_normal_pos\t$new_citation_form"}{"surface_pos"}},  $surface_pos );
	push( @{$dict{"$new_normal_form\t$new_normal_reading\t$new_normal_pos\t$new_citation_form"}{"surface_form"}}, $normal_reading );
	push( @{$dict{"$new_normal_form\t$new_normal_reading\t$new_normal_pos\t$new_citation_form"}{"surface_pos"}},  $normal_pos );
    }

    for my$norm ( sort { $a cmp $b } keys %dict ) {
	my %cache;
	for ( my$i = 0; $i < @{$dict{$norm}{"surface_form"}}; ++$i ) {
	    my $surface_form = $dict{$norm}{"surface_form"}[$i];
	    my $surface_pos  = $dict{$norm}{"surface_pos"}[$i];
	    if ( ! defined $cache{"$surface_form\t$surface_pos"} ) {
		print "$surface_form\t$surface_pos\t";
	    }
	    $cache{"$surface_form\t$surface_pos"} = 1;
	}
	print "$norm\n";
    }
}


sub rewrite {

    my ( $surface_form, $surface_pos, $normal_form, $normal_reading, $normal_pos, $citation_form ) = @_;
    my ( $normal_pos1, $normal_pos2, $normal_ctype, $normal_cform ) = split( /,/, $normal_pos );

    if ( defined $rule1_{$surface_form} && defined $rule1_{$surface_form}{$surface_pos} ) {
	( $normal_form, $normal_reading, $normal_pos, $citation_form ) = @{$rule1_{$surface_form}{$surface_pos}};
    }
	
    if ( defined $rule2_{$normal_ctype} && defined $rule2_{$normal_ctype}{$normal_cform} ) {
	for my$rule ( @{$rule2_{$normal_ctype}{$normal_cform}} ) {
	    $normal_form    =~ s/$rule->{suffix}$/$rule->{normal_suffix}/;
	    $normal_reading =~ s/$rule->{suffix}$/$rule->{normal_suffix}/;
	    $normal_pos     = "$normal_pos1,$normal_pos2,$normal_ctype,$rule->{normal_cform}";
	}
    }
    return ( $normal_form, $normal_reading, $normal_pos, $citation_form );
}
