#!/usr/bin/env perl

use strict;
use utf8;
binmode STDIN, ":encoding(utf8)";
binmode STDERR, ":encoding(utf8)";
binmode STDOUT, ":encoding(utf8)";

&main();

sub main {

    while ( <STDIN> ) {
	chomp;
	&process_one_line( $_ );
    }
}


sub process_one_line {

    my ( $line ) = @_;

    # Remove numbers such as 1.6
    # Ex: (名詞(普通名詞((読み だくおん)(見出し語 濁音(だく音 1.6)(だくおん 1.6))(意味情報 "代表表記:濁音/だくおん カテゴリ:抽象物 ドメイン:教育・学習"))))
    $line =~ s/([\(\)])\(([^ \(\)]+) [0-9\.]+\)([\(\)])/$1$2$3/g;
    $line =~ s/\(([^ \(\)]+) [0-9\.]+\)([\(\)])/ $1$2/g;
    $line =~ s/([\(\)])\(([^ \(\)]+) [0-9\.]+\)/$1$2 /g;
    $line =~ s/\(([^ \(\)]+) [0-9\.]+\)/ $1 /g;

    # Extract POS
    my ( $pos1, $pos2, $ctype, $cform ) = ( "*", "*", "*", "*" );
    if ( $line =~ s/^\(([^\(]+)// ) {
	$pos1 = $1;
	$line =~ s/\)$//;
    }
    if ( $line =~ s/^\(([^\(]+)// ) {
	$pos2 = $1;
	$line =~ s/\)$//;
    }
    if ( $line =~ s/\(活用型 ([^\)]+)\)// ) {
	( $ctype, $cform ) = ( $1, "基本形" );
    }
    $line =~ s/\(活用形 ([^\)]+)\)//;
    my $surface_pos = "$pos1,$pos2,$ctype,$cform";
    
    # Extract each entry
    for my$entry ( &split_entry( $line ) ) {
	my ( $surface_reading, @surface_forms, $citation_form );
	if ( $entry =~ /\(読み ([^\)]+)\)/ ) {
	    $surface_reading = $1;
	}
	if ( $surface_reading eq "来る" ) {  # Correct the reading of `来る'
	    $surface_reading = "くる"; 
	}
	$surface_reading =~ tr/ァ-ン/ぁ-ん/;
	if ( $entry =~ /\(見出し語 ([^\)]+)\)/ ) {
	    @surface_forms = split( / /, $1 );
	}
	if ( $entry =~ /代表表記:([^\s\"]+)/ ) {
	    $citation_form = $1;
	}else {
	    $citation_form = undef;
	}
	for my$surface_form ( @surface_forms ) {
	    if ( defined $citation_form ) {
		print "$surface_form\t$surface_reading\t$surface_pos\t$citation_form\n";
	    }else {
		print "$surface_form\t$surface_reading\t$surface_pos\t$surface_form/$surface_reading\n";
	    }
	}
    }
}


sub split_entry {

    my ( $line ) = @_;

    my $depth = 0;
    my @entries;
    my $entry = "";
    for my$c ( split( //, $line ) ) {
	if ( $c eq '(' ) {
	    ++$depth;
	}
	if ( $c eq ')' ) {
	    --$depth;
	}
	$entry .= $c;
	if ( $depth == 0 ) {
	    push( @entries, $entry );
	    $entry = "";
	}
    }
    return @entries;
}
