/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.lmdbjni;

import java.nio.charset.Charset;
import org.fusesource.lmdbjni.JNI;
import org.fusesource.lmdbjni.LMDBException;
import org.fusesource.lmdbjni.NativeBuffer;

class Util {
    public static final boolean isAndroid = Util.isAndroid();

    Util() {
    }

    public static String string(long ptr) {
        if (ptr == 0L) {
            return null;
        }
        return new String(NativeBuffer.create(ptr, JNI.strlen(ptr)).toByteArray(), Charset.defaultCharset());
    }

    public static void checkErrorCode(int rc) {
        if (rc != 0) {
            String msg = Util.string(JNI.mdb_strerror(rc));
            throw new LMDBException(msg, rc);
        }
    }

    public static void checkArgNotNull(Object value, String name) {
        if (value == null) {
            throw new IllegalArgumentException("The " + name + " argument cannot be null");
        }
    }

    static boolean isAndroid() {
        try {
            Class.forName("android.os.Process");
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }
}

