print_cmd()
{
    source $1
    echo "PROFILE: $1"
    echo "------------------------------------------------- runing cmd -------------------------------------------------"
    echo "torchrun $DISTRIBUTED_ARGS finetune_phi.py 
                --model_name_or_path $MODEL 
                --data_path $DATA 
                --eval_data_path $DATA_EVAL 
                --fp16 True 
                --output_dir $OUTPUT_PATH 
                --eval_output_dir $OUTPUT_PATH 
                --num_train_epochs 20 
                --per_device_train_batch_size 16 
                --per_device_eval_batch_size 16 
                --gradient_accumulation_steps 2 
                --evaluation_strategy "epoch" 
                --save_strategy "epoch" 
                --save_total_limit 20 
                --learning_rate 2e-3
                --weight_decay 0.1 
                --adam_beta2 0.95 
                --warmup_ratio 0.01 
                --lr_scheduler_type "cosine" 
                --logging_steps 1 
                --report_to "none" 
                --model_max_length 512 
                --gradient_checkpointing True 
                --lazy_preprocess True 
                --deepspeed finetune/ds_config_zero2.json 
                --classfication True 
                --use_prompt True 
                --only_prompt True 
                --fix_prompt False 
                --prompt_config "finetune/configs/config_prompt_p20.json" 
                --fix_word_embeddings True" 
    echo "--------------------------------------------------------------------------------------------------------------"
    echo ""
}


# "boolq" "cb" "copa" "mrc" "rte" "wic" "snli" "paws" "imdb"
tasks=("snli")
for task in ${tasks[@]}
do 
    # export PROFILE="finetune/configs/finetuning_bikt/${task}_config.sh"
    # print_cmd $PROFILE
    # bash finetune/finetune_ds_phi.sh 

    # export PROFILE="finetune/configs/prompt_tuning/${task}_config.sh"
    # print_cmd $PROFILE
    # bash finetune/prompt_tune_ds_phi.sh 

    export PROFILE="finetune/configs/finetuning_pt/${task}_config.sh"
    print_cmd $PROFILE
    bash finetune/finetuning_pt_ds_phi.sh 
done
