import json
import os
import random


poll_prediction_files = os.listdir("./poll_predictions")
for idx, file in enumerate(poll_prediction_files):
    with open(os.path.join("./poll_predictions", file), "r") as input_file:
        data = json.load(input_file)

    matches = 0
    for el in data:
        reference_idx = el["reference_idx"]
        prediction = el["prediction"]
        if str(reference_idx) in prediction:
            matches += 1
    print(f"Matched {matches} of {len(data)} entries ({matches/len(data)*100}%) for {file}")

    if file == "llama_sft_poll_data_50.json":
        random_matches = 0
        for el in data:
            sample_number = random.randint(1, el["amount_of_options"])
            prediction = el["prediction"]
            if str(sample_number) in prediction:
                random_matches += 1
        print(f"Randomly matched {random_matches} of {len(data)} entries ({random_matches/len(data)*100}%) for {file}")
