/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.lmdbjni;

import org.fusesource.lmdbjni.JNI;
import org.fusesource.lmdbjni.NativeBuffer;
import org.fusesource.lmdbjni.Unsafe;

class Value
extends JNI.MDB_val {
    public Value() {
    }

    public Value(long data, long length) {
        this.mv_data = data;
        this.mv_size = length;
    }

    public Value(NativeBuffer buffer) {
        this(buffer.pointer(), buffer.capacity());
    }

    public static Value create(NativeBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        return new Value(buffer);
    }

    public byte[] toByteArray() {
        if (this.mv_data == 0L) {
            return null;
        }
        if (this.mv_size > Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException("Native slice is larger than the maximum Java array");
        }
        byte[] rc = new byte[(int)this.mv_size];
        if (Unsafe.UNSAFE != null) {
            Unsafe.getBytes(this.mv_data, 0, rc);
        } else {
            JNI.buffer_copy(this.mv_data, 0L, rc, 0L, (long)rc.length);
        }
        return rc;
    }
}

