/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;

public class BinaryHeadFinder
implements HeadFinder {
    private static final long serialVersionUID = 4794072338791804184L;
    private final HeadFinder fallbackHF;

    public BinaryHeadFinder() {
        this(null);
    }

    public BinaryHeadFinder(HeadFinder fallbackHF) {
        this.fallbackHF = fallbackHF;
    }

    @Override
    public Tree determineHead(Tree t) {
        Tree result = this.determineBinaryHead(t);
        if (result == null && this.fallbackHF != null) {
            result = this.fallbackHF.determineHead(t);
        }
        if (result != null) {
            return result;
        }
        throw new IllegalStateException("BinaryHeadFinder: unexpected tree: " + t);
    }

    @Override
    public Tree determineHead(Tree t, Tree parent) {
        Tree result = this.determineBinaryHead(t);
        if (result == null && this.fallbackHF != null) {
            result = this.fallbackHF.determineHead(t, parent);
        }
        if (result != null) {
            return result;
        }
        throw new IllegalStateException("BinaryHeadFinder: unexpected tree: " + t);
    }

    private Tree determineBinaryHead(Tree t) {
        if (t.numChildren() == 1) {
            return t.firstChild();
        }
        String lval = t.firstChild().label().value();
        if (lval != null && lval.startsWith("@")) {
            return t.firstChild();
        }
        String rval = t.lastChild().label().value();
        if (rval.startsWith("@") || rval.equals(".$$.")) {
            return t.lastChild();
        }
        return null;
    }
}

