theory question_23_0

imports Main

begin

typedecl entity

consts
  Hurricanes :: "entity ⇒ bool"
  HighWinds :: "entity ⇒ bool"
  Tornadoes :: "entity ⇒ bool"

(* Explanation 1: A hurricane has high wind speeds. *)
axiomatization where
  explanation_1: "∀x. Hurricanes x ⟶ HighWinds x"

(* Explanation 2: A tornado has high wind speeds. *)
axiomatization where
  explanation_2: "∀x. Tornadoes x ⟶ HighWinds x"

theorem hypothesis:
  assumes asm: "Hurricanes x ∨ Tornadoes y"
  (* Hypothesis: Both hurricanes and tornadoes always have high winds. *)
  shows "HighWinds x ∧ HighWinds y"
proof -
  from asm have "Hurricanes x ⟶ HighWinds x" using explanation_1 by blast
  then have "HighWinds x" if "Hurricanes x" for x using asm by blast
  from asm have "Tornadoes y ⟶ HighWinds y" using explanation_2 by blast
  then have "HighWinds y" if "Tornadoes y" for y using asm by blast
  show ?thesis using asm that1 that2 by blast
qed

end
