theory question_89_6

imports Main

begin

typedecl entity
typedecl event

consts
  MountainBiking :: "event ⇒ bool"
  Bicycling :: "event ⇒ bool"
  Person :: "entity ⇒ bool"
  Riding :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Entity :: "entity ⇒ bool"
  Going :: "event ⇒ bool"
  Through :: "event ⇒ entity ⇒ bool"
  Woods :: "entity ⇒ bool"
  Forest :: "entity ⇒ bool"
  Autumn :: "entity ⇒ bool"
  SeasonOfFall :: "entity ⇒ bool"

(* Explanation: Mountain biking is a type of bicycling. *)
axiomatization where
  explanation: "∀e. MountainBiking e ⟶ Bicycling e"

theorem hypothesis:
  (* Premise: Mountain biking in a forest during the early fall. *)
  assumes asm: "Person x ∧ MountainBiking e ∧ Agent e x ∧ Patient e y ∧ Forest y ∧ SeasonOfFall z ∧ In e z"
  (* Hypothesis: Bicycling through the woods in the Autumn. *)
  shows "∃x y z e. Person x ∧ Bicycling e ∧ Agent e x ∧ Patient e y ∧ Woods y ∧ Autumn z ∧ In e z"
proof -
  from asm have "MountainBiking e" by blast
  then have "Bicycling e" using explanation by blast
  from asm have "Person x" by blast
  from asm have "Agent e x" by blast
  from asm have "Patient e y" by blast
  from asm have "Forest y" by blast
  from asm have "SeasonOfFall z" by blast
  from asm have "In e z" by blast
  then have "Entity z" by blast
  then have "Woods z ∨ Forest z" by blast
  then have "Woods z" by blast
  from asm have "Autumn z" using SeasonOfFall_is_Autumn by blast
  show ?thesis using asm `Person x` `Bicycling e` `Woods z` `Autumn z` by blast
qed

end
