theory question_81_8
imports Main

begin

typedecl entity
typedecl event

consts
  Person :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Outdoors :: "entity ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"
  Bicycle :: "entity ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ event ⇒ bool"
  Jumping :: "entity ⇒ event ⇒ bool"
  Soaring :: "entity ⇒ event ⇒ event ⇒ bool"
  Skyline :: "event ⇒ bool"
  Lake :: "event ⇒ bool"

(* Explanation 1: We define a person being on something as being outdoors. *)
axiomatization where
  explanation_1: "∀x y. Person x ∧ On x y ⟶ Outdoors x"

(* Explanation 2: We define a bicycle as a vehicle that a person can be on. *)
axiomatization where
  explanation_2: "∀x. Bicycle x ⟷ ∃y. Person y ∧ On y x"

theorem hypothesis:
  (* Premise: A person (x) is wearing a helmet (z) while being on a bicycle (y), jumping (e3), and soaring over the ground (e5) in front of a skyline (e4) and next to a lake (e6). *)
  assumes asm: "Person x ∧ Bicycle y ∧ Helmet z ∧ Wearing x z e1 ∧ On x y e2 ∧ Jumping x e3 ∧ Soaring x e3 e5 ∧ Skyline e4 ∧ In x e4 ∧ Lake e6 ∧ NextTo x e6"
  (* Hypothesis: A person (x) is outside (e) and on a bike (y). *)
  shows "∃e. Outside x e ∧ On x y e"
proof -
  from asm have "Person x ∧ Bicycle y ∧ On x y e2 ∧ In x e4" by blast
  then have "Outdoors x" using explanation_1 by blast
  then have "∃e. Outside x e ∧ On x y e" using asm by blast
qed

end
