theory question_80_8
imports Main

begin

typedecl entity

consts
  Copper :: "entity ⇒ bool"
  Metal :: "entity ⇒ bool"
  ElectricalConductor :: "entity ⇒ bool"
  ConductsElectricity :: "entity ⇒ bool"

(* Explanation 1: Copper is a metal. *)
axiomatization where
  explanation_1: "∀x. Copper x ⟶ Metal x"

(* Explanation 2: All copper is an electrical conductor. *)
axiomatization where
  explanation_2: "∀x. Copper x ⟶ ElectricalConductor x"

(* Explanation 3: Not all materials that conduct electricity are copper. *)
axiomatization where
  explanation_3: "∃x. ConductsElectricity x ∧ ¬Copper x"

theorem hypothesis:
  (* Premise: No premise given *)
  assumes asm: "True"
  (* Hypothesis: Copper is the material that conducts electricity. *)
  shows "∃x. Copper x ⟷ ConductsElectricity x"
proof -
  have "∃x. Copper x ⟹ ConductsElectricity x" using explanation_2 by blast
  have "∃x. ConductsElectricity x ∧ ¬Copper x" using explanation_3 by blast
  then have "¬ (∀x. Copper x ⟺ ConductsElectricity x)" by blast
  then show ?thesis by blast
qed

end
