theory question_57_0

imports Main

begin
typedecl entity
typedecl event
consts
  MaintenanceWorker :: "entity ⇒ bool"
  Worker :: "entity ⇒ bool"
  Statue :: "entity ⇒ bool"
  Walking :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  By :: "event ⇒ entity ⇒ bool"
  Past :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A maintenance person walking past a statue. *)
axiomatization where
  explanation_1: "∃x y e. MaintenancePerson x ∧ Statue y ∧ Walking e ∧ Agent e x ∧ Past e y"

theorem hypothesis:
  (* Premise: A maintenance worker walking past a statue. *)
  assumes asm: "MaintenanceWorker x ∧ Statue y ∧ Walking e ∧ Agent e x ∧ Past e y"
  (* Hypothesis: worker walking by a statue *)
  shows "∃x y e. Worker x ∧ Statue y ∧ Walking e ∧ Agent e x ∧ By e y"
proof -
  from asm have "MaintenanceWorker x ∧ Statue y ∧ Walking e ∧ Agent e x ∧ Past e y" by blast
  then have "Worker x ∧ Statue y ∧ Walking e ∧ Agent e x" using explanation_1 by blast
  then show ?thesis using asm `Worker x` `Statue y` `Walking e` `Agent e x` by blast
qed

end
