theory question_19_8

imports Main

begin
typedecl entity
typedecl event

consts
  Woman :: "entity ⇒ bool"
  PurpleSweater :: "entity ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ bool"
  WearingPurpleSweater :: "entity ⇒ bool"
  OddLook :: "entity ⇒ bool"

(* Explanation 1: If an entity is a purple sweater and is worn by a person, then the person is wearing the purple sweater. *)
axiomatization where
  explanation_1: "∀x y. PurpleSweater y ∧ Wearing x y ⟶ WearingPurpleSweater x"

(* Explanation 2: If a person has an odd look and is wearing an entity, then the entity has an odd look. *)
axiomatization where
  explanation_2: "∀x y. OddLook x ∧ Wearing x y ⟶ OddLook y"

theorem hypothesis:
  (* Premise: *)
  assumes asm: "Woman x ∧ PurpleSweater y ∧ Wearing x y"
  (* Hypothesis: A woman in a purple sweater has an odd look on her face. *)
  shows "∃x. Woman x ∧ OddLook x"
proof -
  from asm have "Woman x" by blast
  from asm have "Wearing x y" by blast
  from asm have "PurpleSweater y" by blast
  from asm have "OddLook x" using explanation_2 by blast
  show ?thesis using `Woman x` `OddLook x` by blast
qed

end
