theory question_96_0

imports Main

begin

typedecl entity
typedecl event
consts
  Children :: "entity ⇒ bool"
  Adults :: "entity ⇒ bool"
  People :: "entity ⇒ bool"
  Pool :: "entity ⇒ bool"
  RedStaircase :: "entity ⇒ bool"
  Swimming :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  In :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Both children and adults are people. *)
axiomatization where
  explanation_1: "∀x. Children x ∨ Adults x ⟶ People x"

theorem hypothesis:
  (* Premise: Children and adults swim in large pool with red staircase. *)
  assumes asm: "Children x ∧ Adults y ∧ Pool z ∧ RedStaircase z ∧ Swimming e ∧ Agent e x ∧ Agent e y ∧ In e z"
  (* Hypothesis: A group of people are swimming. *)
  shows "∃x y e. People x ∧ Swimming e ∧ Agent e y"
proof -
  from asm have "Children x" by blast
  from this have "People x" using explanation_1 by blast
  from asm have "Swimming e" by blast
  show ?thesis using `People x` `Swimming e` by blast
qed

end
