theory question_90_1

imports Main

begin

typedecl entity
typedecl event
consts
 Man :: "entity ⇒ bool"
 Walking :: "event ⇒ bool"
 Running :: "event ⇒ bool"
 Suddenly :: "event ⇒ bool"
 Scary :: "event ⇒ bool"
 Seen :: "event ⇒ entity ⇒ bool"

(* Explanation 1: If a man is walking down the street and suddenly starts to run, it can be assumed that he has seen something scary. *)
axiomatization where
explanation_1: "∀x y e. Man x ∧ Walking y ∧ Suddenly e ∧ Run e ∧ Scary e ⟶ Seen x e"

theorem hypothesis:
 (* Premise: A man is walking down the street and suddenly starts to run. *)
 assumes asm: "Man x ∧ Walking y ∧ Suddenly e ∧ Run e"
 (* Hypothesis: The man has seen something scary. *)
 shows "∃e. Seen x e"
proof -
 from asm have "Man x" by blast
 then have "Walking y" using explanation_1 by blast
 then have "Suddenly e" using explanation_1 by blast
 then have "Run e" using explanation_1 by blast
 then have "Scary e" using explanation_1 by blast
 then show ?thesis using `Seen x e` by blast
qed

end
