theory question_61_1

imports Main

begin

typedecl entity

consts
  LargestBodyInOurSolarSystem :: "entity ⇒ bool"
  Sun :: "entity ⇒ bool"
  Star :: "entity ⇒ bool"
  CelestialObject :: "entity ⇒ bool"
  CelestialBody :: "entity ⇒ bool"

(* Explanation 1: The largest celestial body in our solar system is the Sun. *)
axiomatization where
  explanation_1: "∀x. LargestCelestialBodyInOurSolarSystem x ⟶ Sun x"

(* Explanation 2: the Sun is a kind of star. *)
axiomatization where
  explanation_2: "∀x. Sun x ⟶ Star x"  

(* Explanation 3: a star is a kind of celestial object; celestial body. *)
axiomatization where
  explanation_3: "∀x. Star x ⟶ CelestialObject x ∧ CelestialBody x"  

theorem hypothesis:
  assumes asm: "LargestBodyInOurSolarSystem x"
  (* Hypothesis: The largest body in our solar system is the Sun. *)
  shows "Sun x"
proof -
  from asm have "LargestBodyInOurSolarSystem x" by simp
  then show ?thesis using explanation_1 by blast
qed

end
