theory question_61_2

imports Main

begin

typedecl entity
typedecl event

consts
  Erosion :: "entity ⇒ bool"
  Canyons :: "entity ⇒ bool"
  Process :: "entity ⇒ bool"
  Forms :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Erosion is the process that forms canyons. *)
axiomatization where
  explanation_1: "∀x y e. Erosion x ∧ Canyons y ∧ Process x ∧ Forms e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  assumes asm: "Erosion x"
  (* Hypothesis: Erosion forms canyons. *)
  shows "∃x y e. Erosion x ∧ Canyons y ∧ Forms e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Erosion x" by simp
  then obtain y e where "Canyons y ∧ Forms e ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
  then show ?thesis using asm `Canyons y` `Forms e` `Agent e x` `Patient e y` by blast
qed

end
