theory question_81_1

imports Main


begin

typedecl entity
typedecl event

consts
  Population :: "entity ⇒ bool"
  Gets :: "event ⇒ bool"
  MuchSmaller :: "event ⇒ bool"
  Occurs :: "event ⇒ bool"
  BottleneckEffect :: "event ⇒ bool"
  Reduced :: "event ⇒ bool"
  ExternalMigration :: "event ⇒ bool"
  Lead :: "event ⇒ bool"
  Reduction :: "event ⇒ bool"
  Sudden :: "event ⇒ bool"
  PopulationSize :: "event ⇒ bool"
  Caused :: "event ⇒ bool"
  Trigger :: "event ⇒ bool"
  SuddenReduction :: "event ⇒ bool"

(* Explanation 1: Bottleneck effect occurs when a population suddenly gets much smaller. *)
axiomatization where
  explanation_1: "∀e p. Population p ∧ Gets e ∧ MuchSmaller e ⟶ (Occurs e ∧ BottleneckEffect e)"

(* Explanation 2: Population growth is reduced by external migration. *)
axiomatization where
  explanation_2: "∀e. Reduced e ∧ ExternalMigration e ⟶ PopulationGrowth e"

(* Explanation 3: External migration can lead to a sudden reduction in population size. *)
axiomatization where
  explanation_3: "∀e. Lead e ∧ Reduction e ∧ Sudden e ∧ PopulationSize e ⟶ ExternalMigration e"

(* Explanation 4: The sudden reduction in population size caused by external migration can trigger the bottleneck effect. *)
axiomatization where
  explanation_4: "∀e1 e2. Caused e1 ∧ Trigger e2 ∧ BottleneckEffect e2 ⟶ (SuddenReduction e1 ∧ PopulationSize e1 ∧ ExternalMigration e1)"


theorem hypothesis:
 assumes asm: "Occur e ∧ ExternalMigration e"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
 shows "BottleneckEffect e"
proof -
  from asm have "Occur e ∧ ExternalMigration e" by simp
  then have "Population p ∧ Gets e ∧ MuchSmaller e" using explanation_1 by blast
  then have "Lead e ∧ Reduction e ∧ Sudden e ∧ PopulationSize e" using explanation_3 by blast
  then have "Caused e1 ∧ Trigger e2 ∧ BottleneckEffect e2" using explanation_4 by blast
  then have "SuddenReduction e1 ∧ PopulationSize e1 ∧ ExternalMigration e1" using asm by blast
  then show ?thesis using `BottleneckEffect e2` by blast
qed

end
