theory question_98_4

imports Main

begin
typedecl entity
typedecl event

consts
  Young :: "entity ⇒ bool"
  Man :: "entity ⇒ bool"
  Goggles :: "entity ⇒ bool"
  Pool :: "event ⇒ bool"
  Jumping :: "event ⇒ bool"
  OutOf :: "event ⇒ entity ⇒ bool"
  Splashing :: "event ⇒ bool"
  Everywhere :: "event ⇒ bool"
  In :: "event ⇒ entity ⇒ event ⇒ bool"

(* Explanation 1: The young man wearing goggles is a man. *)
axiomatization where
  explanation_1: "∀x. Young x ∧ Man x ∧ Goggles x"

theorem hypothesis:
  (* Premise: A young man wearing goggles, is jumping out of a pool, splashing water everywhere. *)
  assumes asm: "Young x ∧ Man x ∧ Goggles x ∧ Pool e1 ∧ Jumping e2 ∧ Splashing e2 ∧ Everywhere e2 ∧ OutOf e2 x ∧ In e2 x e1"
  (* Hypothesis: Man jumping out of a pool. *)
  shows "∃x e. Man x ∧ Pool e ∧ Jumping e ∧ OutOf e x"
proof -
  from asm have "Young x ∧ Man x ∧ Goggles x" by blast
  then have "Man x" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
