theory question_66_0
imports Main

begin
typedecl entity
typedecl event
consts
  Bartender :: "entity ⇒ bool"
  Person :: "entity ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ bool"
  Black :: "entity ⇒ bool"
  Male :: "entity ⇒ bool"
  DressedIn :: "entity ⇒ entity ⇒ bool"
  SleevesRolledUp :: "entity ⇒ entity ⇒ bool"
  Making :: "event ⇒ bool"
  Drink :: "entity"
  InGlass :: "event ⇒ entity ⇒ bool"
  MartiniGlass :: "entity ⇒ bool"

(* Explanation 1: A bartender, who is a person, is wearing black. *)
axiomatization where
  explanation_1: "∀x. Bartender x ∧ Person x ∧ Wearing x Black"

theorem hypothesis:
  (* Premise: A male bartender dressed in all black with his sleeves rolled up to elbow height making a drink in a martini glass. *)
  assumes asm: "Bartender x ∧ Male x ∧ DressedIn x Black ∧ SleevesRolledUp x ElbowHeight ∧ Making e ∧ Agent e x ∧ Patient e Drink ∧ InGlass e MartiniGlass"
  (* Hypothesis: A person in black *)
  shows "∃x. Person x ∧ Black x"
proof -
  from asm have "Bartender x ∧ Person x ∧ Wearing x Black" using explanation_1 by blast
  then have "Person x ∧ Black x" by blast
  then show ?thesis by blast
qed

end
