theory question_39_3
imports Main
begin

typedecl entity
typedecl event

consts
  Boys :: "entity ⇒ bool"
  Basketball :: "event ⇒ bool"
  Playing :: "event ⇒ bool"
  Uniforms :: "entity ⇒ bool"
  Seen :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ entity ⇒ entity ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ bool"
  Participants :: "entity ⇒ event ⇒ bool"
  EngagedIn :: "entity ⇒ bool"
  TeamSports :: "entity ⇒ bool"
  Green :: "entity ⇒ bool"
  White :: "entity ⇒ bool"
  Play :: "event ⇒ bool"
  With :: "entity ⇒ entity ⇒ entity ⇒ entity ⇒ bool"

(* Explanation 1: Boys playing basketball are typically seen in uniforms. *)
axiomatization where
  explanation_1: "∀x e. Boys x ∧ Basketball e ∧ Playing e ⟶ (∃y. Uniforms y ∧ Seen e ∧ Agent e x y)"

(* Explanation 2: Boys playing basketball are often participants in the game. *)
axiomatization where
  explanation_2: "∀x e. Boys x ∧ Basketball e ∧ Playing e ⟶ Participants x e"

(* Explanation 3: Boys playing basketball are commonly engaged in team sports. *)
axiomatization where
  explanation_3: "∀x e. Boys x ∧ Basketball e ∧ Playing e ⟶ EngagedIn x"

theorem hypothesis:
  (* Premise: Two boys in green and white uniforms play basketball with two boys in blue and white uniforms. *)
  assumes asm: "Boys x ∧ Boys y ∧ Boys z ∧ Boys w ∧ Uniforms e ∧ Green e ∧ White e ∧ Play e ∧ Agent e x y z w ∧ With x y z w"
  (* Hypothesis: Boys are playing basketball. *)
  shows "∃x e. Boys x ∧ Basketball e ∧ Playing e ∧ Agent e x"
proof -
  from asm have "Boys x ∧ Uniforms e ∧ Green e ∧ White e ∧ Play e ∧ Agent e x y z w ∧ With x y z w" by blast
  then have "Boys x ∧ Basketball e ∧ Playing e" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
