import abc

from typing import Any

from smaug.typing import Text
from smaug.model.typing import MaskingPattern


class Text2Text(abc.ABC):
    """Base class for models that map a sequence to other sequence."""

    @abc.abstractmethod
    def __call__(self, text: Text) -> Text:
        pass


class TokenClassification(abc.ABC):
    """Base class for models that classify a sequence or its tokens."""

    @abc.abstractmethod
    def __call__(self, text: Text) -> Any:
        pass


class MaskedLanguageModel(abc.ABC):
    """Base class for masked language models.

    Models that implement this class should receive sentences with
    masked tokens, using the defined masking pattern and return content
    generated by processing the tokens."""

    @classmethod
    @abc.abstractmethod
    def masking_pattern(cls) -> MaskingPattern:
        """Defines the masking pattern that should be used to interact with this
        model.

        If the masking pattern is an iterator, a new object is created at each invocation."""
        pass
