###
 # @Author: Roy
 # @Date: 2021-08-16 20:24:42
 # @LastEditTime: 2021-11-15 15:00:47
 # @LastEditors: Please set LastEditors
 # @Description: In User Settings Edit
 # @FilePath: /open_clip/train.sh
### 
DEVICES=0,

# train
merged_train_data=/home/roy/open_clip/merged_train.csv # GCC and MSCOCO
cc_train_data=/home/roy/open_clip/Train_GCC-training_output.csv # GCC
coco_train_data=/home/roy/CLIP/coco_train.csv # MSCOCO
flick30k_train_data=/home/roy/open_clip_2/open_clip-main/src/flickr30k_train.csv

# val
cc_val_data=/home/roy/open_clip/Validation_GCC-1.1.0-Validation_output.csv # GCC val
coco_val_data=/home/roy/CLIP/coco_val.csv # MSCOCO val

# temp
temp=0.09

# rank for LoRA
rank=36


CUDA_VISIBLE_DEVICES=$DEVICES python -u -Wignore training/main.py \
    --save-frequency 1 \
    --train-data=$coco_train_data  \
    --val-data=$coco_val_data  \
    --csv-img-key filepath \
    --csv-caption-key title \
    --warmup 10000 \
    --batch-size=96 \
    --lr=3e-4 \
    --wd=0.0001 \
    --epochs=5 \
    --workers=30 \
    --model ViT-B/32 \
    --precision fp32 \
    --report-to tensorboard \
    --gpu 0 \
    --rank $rank \
    --name pit_small\
    --ance \