#!/usr/bin/env bash

cd ../ClozeGenerators

rm -r /nas/home/qasemi/Mowgli-CoreQuisite/outputs/DICE/*

ALLPRED=(
       /r/UsedFor
#        /r/CapableOf
#        /r/Desires
#        /r/CausesDesire
#        /r/Causes
#        /r/RelatedTo /r/IsA /r/PartOf /r/Desires /r/NotDesires /r/CreatedBy /r/MannerOf
)
ALLMODELS=(
#     bert-large-cased
    roberta-base
#     gpt2
#     bart-large
#     xlm-roberta-large
#     transfo-xl-wt103'
)
for PREDICATE in ${ALLPRED[*]};
do
    for MODEL in ${ALLMODELS[*]};
    do
        python DICEClozeGenerator.py \
            graph_path=/nas/home/qasemi/mowgli-cache/DICE/conceptnet-dice.csv \
            max_len=-1 \
            lexic='Base' \
            perplexity=true \
            perplexity_model=${MODEL} \
            predicates=["${PREDICATE}"] \
            hydra.run.dir=/nas/home/qasemi/Mowgli-CoreQuisite/outputs/DICE/${PREDICATE}
    done
done
