import numpy as np
import matplotlib.pyplot as plt
from sklearn import manifold, datasets
import xlrd
from matplotlib import font_manager



index2ccharacter={}
index2cid={}
cid2id={}


def readJia2():

    wb = xlrd.open_workbook('../data/20210520_oracle-radical.xlsx')
    # 按工作簿定位工作表
    sh = wb.sheet_by_name('甲骨文-部件对应表')
    count=0
    ccount=0
    for i in range(sh.nrows):
        if i == 0:
            continue
        # print(sh.row_values(i))
        li = sh.row_values(i)
        id = li[0]
        id=id.split("_")[3]+id.split("_")[4]
        cha=li[1]

        pp=li[3]
        if "," in pp:
            pp=pp.split(",")
        else:
            pp=[pp]

        if id[:-1] not in cid2id.keys():
            cid2id[id[:-1]]=[id]
            index2cid[ccount] = id[:-1]
            index2ccharacter[ccount] = cha
            ccount=ccount+1
        else:
            cid2id[id[:-1]].append(id)
        #print(id +" "+pp[0])


def loadData(filePath):
    fr = open(filePath, 'r+')
    lines = fr.readlines()
    retName = []
    retData = []
    for k,line in enumerate(lines):
        if k==0:
            continue

        items = line.strip().split(' ')
        retName.append(float(k))
        retData.append([float(items[i]) for i in range(1, len(items))])
    return retName, retData




def getmixLCSNetFiguresimi(v1=0.4,v2=0.3,v3=0.4):
    cpair2LCSsimi_np = np.load('../data/results/jia_RLCS_simi_np.npy')
    cpair2Netsimi_np = np.load('../data/results/jia_graph_simi_np.npy')
    cpair2Figuresimi_np = np.load('../data/results/jia_pic_simi_np.npy')
    similarity_np = v1 * cpair2LCSsimi_np+v2*cpair2Netsimi_np+v3 * cpair2Figuresimi_np

    return similarity_np




readJia2()
X=getmixLCSNetFiguresimi()
#print(X.shape)
y=[1]*2543
y=np.array(y)
# y=cluster(X)

z=[]
for i in range(len(y)):
    thecharacter=index2ccharacter[i]
    if "+" in thecharacter:
        thecharacter=thecharacter.replace("+","")
    z.append(thecharacter)


'''t-SNE'''
tsne = manifold.TSNE(n_components=2, init='pca', random_state=500)
X_tsne = tsne.fit_transform(X)

my_font = font_manager.FontProperties(fname="45691296228.ttf")

print("Org data dimension is {}.Embeddeddatadimension is {}".format(X.shape[-1], X_tsne.shape[-1]))

'''嵌入空间可视化'''
x_min, x_max = X_tsne.min(0), X_tsne.max(0)
X_norm = (X_tsne - x_min) / (x_max - x_min)  # 归一化
plt.figure(figsize=(10,5))
# print(len(range(X_norm.shape[0])))
for i in range(X_norm.shape[0]):
    plt.text(X_norm[i, 0], X_norm[i, 1], str(z[i]), color=plt.cm.Set1(y[i]),fontproperties=my_font,
             fontdict={'weight': 'bold', 'size': 9})
plt.xticks([])
plt.yticks([])
plt.show()

