/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.meteor.scorer;

import edu.cmu.meteor.aligner.Aligner;
import edu.cmu.meteor.aligner.Alignment;
import edu.cmu.meteor.aligner.Match;
import edu.cmu.meteor.scorer.MeteorConfiguration;
import edu.cmu.meteor.scorer.MeteorStats;
import edu.cmu.meteor.util.Constants;
import edu.cmu.meteor.util.Normalizer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeteorScorer {
    private Aligner aligner;
    private String language;
    private int langID;
    private boolean normalize;
    private boolean keepPunctuation;
    private boolean lowerCase;
    private double alpha;
    private double beta;
    private double gamma;
    private double delta;
    private ArrayList<Double> moduleWeights;
    private boolean charBased;

    public MeteorScorer() {
        MeteorConfiguration meteorConfiguration = new MeteorConfiguration();
        this.loadConfiguration(meteorConfiguration);
    }

    public MeteorScorer(MeteorConfiguration meteorConfiguration) {
        this.loadConfiguration(meteorConfiguration);
    }

    public MeteorScorer(MeteorScorer meteorScorer) {
        this.language = meteorScorer.language;
        this.langID = meteorScorer.langID;
        this.normalize = meteorScorer.normalize;
        this.keepPunctuation = meteorScorer.keepPunctuation;
        this.lowerCase = meteorScorer.lowerCase;
        this.alpha = meteorScorer.alpha;
        this.beta = meteorScorer.beta;
        this.gamma = meteorScorer.gamma;
        this.delta = meteorScorer.delta;
        this.moduleWeights = new ArrayList<Double>(meteorScorer.moduleWeights);
        this.aligner = new Aligner(meteorScorer.aligner);
        this.charBased = meteorScorer.charBased;
    }

    private void loadConfiguration(MeteorConfiguration meteorConfiguration) {
        this.language = meteorConfiguration.getLanguage();
        this.langID = meteorConfiguration.getLangID();
        this.setNormalize(meteorConfiguration.getNormalization());
        ArrayList<Double> arrayList = meteorConfiguration.getParameters();
        this.alpha = arrayList.get(0);
        this.beta = arrayList.get(1);
        this.gamma = arrayList.get(2);
        this.delta = arrayList.get(3);
        this.moduleWeights = meteorConfiguration.getModuleWeights();
        this.aligner = new Aligner(this.language, meteorConfiguration.getModules(), meteorConfiguration.getModuleWeights(), meteorConfiguration.getBeamSize(), meteorConfiguration.getWordFileURL(), meteorConfiguration.getSynDirURL(), meteorConfiguration.getParaDirURL(), Constants.PARTIAL_COMPARE_TOTAL);
        ArrayList<Integer> arrayList2 = meteorConfiguration.getModules();
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        for (int n : arrayList2) {
            if (n == 0) {
                arrayList3.add(1.0);
                continue;
            }
            if (n == 1) {
                arrayList3.add(0.5);
                continue;
            }
            if (n == 2) {
                arrayList3.add(0.5);
                continue;
            }
            arrayList3.add(0.5);
        }
        this.aligner.updateModuleWeights(arrayList3);
        this.charBased = meteorConfiguration.getCharBased();
    }

    private void setNormalize(int n) {
        if (n == 1) {
            this.normalize = false;
            this.keepPunctuation = true;
            this.lowerCase = true;
        } else if (n == 2) {
            this.normalize = true;
            this.keepPunctuation = true;
            this.lowerCase = true;
        } else if (n == 3) {
            this.normalize = true;
            this.keepPunctuation = false;
            this.lowerCase = true;
        } else {
            this.normalize = false;
            this.keepPunctuation = true;
            this.lowerCase = false;
        }
    }

    public void updateModuleWeights(ArrayList<Double> arrayList) {
        this.aligner.updateModuleWeights(arrayList);
    }

    public MeteorStats getMeteorStats(ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        Alignment alignment = this.aligner.align(arrayList, arrayList2);
        return this.getMeteorStats(alignment);
    }

    public MeteorStats getMeteorStats(String string, String string2) {
        if (this.normalize) {
            string = Normalizer.normalizeLine(string, this.langID, this.keepPunctuation);
            string2 = Normalizer.normalizeLine(string2, this.langID, this.keepPunctuation);
        }
        if (this.lowerCase) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        Alignment alignment = this.aligner.align(string, string2);
        return this.getMeteorStats(alignment);
    }

    public MeteorStats getMeteorStats(String string, ArrayList<String> arrayList) {
        if (this.normalize) {
            string = Normalizer.normalizeLine(string, this.langID, this.keepPunctuation);
        }
        if (this.lowerCase) {
            string = string.toLowerCase();
        }
        MeteorStats meteorStats = new MeteorStats();
        meteorStats.score = -1.0;
        for (String string2 : arrayList) {
            if (this.normalize) {
                string2 = Normalizer.normalizeLine(string2, this.langID, this.keepPunctuation);
            }
            if (this.lowerCase) {
                string2 = string2.toLowerCase();
            }
            Alignment alignment = this.aligner.align(string, string2);
            MeteorStats meteorStats2 = this.getMeteorStats(alignment);
            if (!(meteorStats2.score > meteorStats.score)) continue;
            meteorStats = meteorStats2;
        }
        return meteorStats;
    }

    public MeteorStats getMeteorStats(Alignment alignment) {
        MeteorStats meteorStats = new MeteorStats();
        if (this.charBased) {
            meteorStats.testLength = 0.0;
            for (String string : alignment.words1) {
                meteorStats.testLength += (double)string.length();
            }
            meteorStats.referenceLength = 0.0;
            for (String string : alignment.words2) {
                meteorStats.referenceLength += (double)string.length();
            }
            meteorStats.testFunctionWords = 0.0;
            Object object = alignment.line1FunctionWords.iterator();
            while (object.hasNext()) {
                int n = (Integer)object.next();
                meteorStats.testFunctionWords += (double)alignment.words1.get(n).length();
            }
            meteorStats.referenceFunctionWords = 0.0;
            object = alignment.line2FunctionWords.iterator();
            while (object.hasNext()) {
                int n = (Integer)object.next();
                meteorStats.referenceFunctionWords += (double)alignment.words2.get(n).length();
            }
            object = new int[alignment.moduleContentMatches1.size()];
            int[] nArray = new int[alignment.moduleContentMatches1.size()];
            int[] nArray2 = new int[alignment.moduleContentMatches1.size()];
            int[] nArray3 = new int[alignment.moduleContentMatches1.size()];
            for (Match match : alignment.matches) {
                int n;
                if (match == null) continue;
                for (n = 0; n < match.matchLength; ++n) {
                    if (alignment.line1FunctionWords.contains(match.matchStart + n)) {
                        int n2 = match.module;
                        nArray2[n2] = nArray2[n2] + alignment.words1.get(match.matchStart + n).length();
                        continue;
                    }
                    Object object2 = object;
                    int n3 = match.module;
                    object2[n3] = object2[n3] + alignment.words1.get(match.matchStart + n).length();
                }
                for (n = 0; n < match.length; ++n) {
                    if (alignment.line2FunctionWords.contains(match.start + n)) {
                        int n4 = match.module;
                        nArray3[n4] = nArray3[n4] + alignment.words2.get(match.start + n).length();
                        continue;
                    }
                    int n5 = match.module;
                    nArray[n5] = nArray[n5] + alignment.words2.get(match.start + n).length();
                }
            }
            for (int i = 0; i < alignment.moduleContentMatches1.size(); ++i) {
                meteorStats.testStageMatchesContent.add((double)object[i]);
                meteorStats.referenceStageMatchesContent.add(Double.valueOf(nArray[i]));
                meteorStats.testStageMatchesFunction.add(Double.valueOf(nArray2[i]));
                meteorStats.referenceStageMatchesFunction.add(Double.valueOf(nArray3[i]));
            }
        } else {
            meteorStats.testLength = alignment.words1.size();
            meteorStats.referenceLength = alignment.words2.size();
            meteorStats.testFunctionWords = alignment.line1FunctionWords.size();
            meteorStats.referenceFunctionWords = alignment.line2FunctionWords.size();
            meteorStats.testStageMatchesContent = new ArrayList();
            int n = 0;
            while (n < alignment.moduleContentMatches1.size()) {
                meteorStats.testStageMatchesContent.add((double)alignment.moduleContentMatches1.get(n++));
            }
            meteorStats.referenceStageMatchesContent = new ArrayList();
            n = 0;
            while (n < alignment.moduleContentMatches2.size()) {
                meteorStats.referenceStageMatchesContent.add((double)alignment.moduleContentMatches2.get(n++));
            }
            meteorStats.testStageMatchesFunction = new ArrayList();
            n = 0;
            while (n < alignment.moduleFunctionMatches1.size()) {
                meteorStats.testStageMatchesFunction.add((double)alignment.moduleFunctionMatches1.get(n++));
            }
            meteorStats.referenceStageMatchesFunction = new ArrayList();
            n = 0;
            while (n < alignment.moduleFunctionMatches2.size()) {
                meteorStats.referenceStageMatchesFunction.add((double)alignment.moduleFunctionMatches2.get(n++));
            }
        }
        meteorStats.chunks = alignment.numChunks;
        for (int i = 0; i < meteorStats.testStageMatchesContent.size(); ++i) {
            meteorStats.testTotalMatches += meteorStats.testStageMatchesContent.get(i).doubleValue();
            meteorStats.testTotalMatches += meteorStats.testStageMatchesFunction.get(i).doubleValue();
            meteorStats.referenceTotalMatches += meteorStats.referenceStageMatchesContent.get(i).doubleValue();
            meteorStats.referenceTotalMatches += meteorStats.referenceStageMatchesFunction.get(i).doubleValue();
            meteorStats.testWordMatches += (double)alignment.moduleContentMatches1.get(i).intValue();
            meteorStats.testWordMatches += (double)alignment.moduleFunctionMatches1.get(i).intValue();
            meteorStats.referenceWordMatches += (double)alignment.moduleContentMatches2.get(i).intValue();
            meteorStats.referenceWordMatches += (double)alignment.moduleFunctionMatches2.get(i).intValue();
        }
        this.computeMetrics(meteorStats);
        meteorStats.alignment = alignment;
        return meteorStats;
    }

    public void computeMetrics(MeteorStats meteorStats) {
        int n;
        meteorStats.testWeightedMatches = 0.0;
        meteorStats.referenceWeightedMatches = 0.0;
        meteorStats.testWeightedLength = this.delta * (meteorStats.testLength - meteorStats.testFunctionWords) + (1.0 - this.delta) * meteorStats.testFunctionWords;
        meteorStats.referenceWeightedLength = this.delta * (meteorStats.referenceLength - meteorStats.referenceFunctionWords) + (1.0 - this.delta) * meteorStats.referenceFunctionWords;
        for (n = 0; n < this.moduleWeights.size(); ++n) {
            meteorStats.testWeightedMatches += meteorStats.testStageMatchesContent.get(n) * this.moduleWeights.get(n) * this.delta;
        }
        for (n = 0; n < this.moduleWeights.size(); ++n) {
            meteorStats.referenceWeightedMatches += meteorStats.referenceStageMatchesContent.get(n) * this.moduleWeights.get(n) * this.delta;
        }
        for (n = 0; n < this.moduleWeights.size(); ++n) {
            meteorStats.testWeightedMatches += meteorStats.testStageMatchesFunction.get(n) * this.moduleWeights.get(n) * (1.0 - this.delta);
        }
        for (n = 0; n < this.moduleWeights.size(); ++n) {
            meteorStats.referenceWeightedMatches += meteorStats.referenceStageMatchesFunction.get(n) * this.moduleWeights.get(n) * (1.0 - this.delta);
        }
        meteorStats.precision = meteorStats.testWeightedMatches / meteorStats.testWeightedLength;
        meteorStats.recall = meteorStats.referenceWeightedMatches / meteorStats.referenceWeightedLength;
        meteorStats.f1 = 2.0 * meteorStats.precision * meteorStats.recall / (meteorStats.precision + meteorStats.recall);
        meteorStats.fMean = 1.0 / ((1.0 - this.alpha) / meteorStats.precision + this.alpha / meteorStats.recall);
        double d = meteorStats.testTotalMatches == meteorStats.testLength && meteorStats.referenceTotalMatches == meteorStats.referenceLength && meteorStats.chunks == 1.0 ? 0.0 : meteorStats.chunks / ((meteorStats.testWordMatches + meteorStats.referenceWordMatches) / 2.0);
        meteorStats.fragPenalty = this.gamma * Math.pow(d, this.beta);
        double d2 = meteorStats.fMean * (1.0 - meteorStats.fragPenalty);
        meteorStats.score = Double.isNaN(d2) ? 0.0 : Math.max(d2, 0.0);
    }
}

