/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.lexicalitems;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import simplenlg.features.AdjectiveDegree;
import simplenlg.features.AdjectivePosition;
import simplenlg.features.AdjectiveType;
import simplenlg.features.Case;
import simplenlg.features.Category;
import simplenlg.features.Gender;
import simplenlg.features.NumberAgr;
import simplenlg.lexicon.lexicalitems.ContentWord;
import simplenlg.lexicon.lexicalitems.Noun;
import simplenlg.lexicon.morph.AdjectiveInflection;

public class Adjective
extends ContentWord {
    private String positiveForm;
    private String comparativeForm;
    private String superlativeForm;
    boolean elideFinalE;
    Set<AdjectivePosition> positions;
    AdjectiveType type;

    public Adjective(String baseform) {
        super(baseform);
        this.category = Category.ADJECTIVE;
        this.positions = new HashSet<AdjectivePosition>();
        this.type = AdjectiveType.NON_STATIVE;
        this.positiveForm = this.baseForm;
        this.comparativeForm = this.baseForm + "er";
        this.superlativeForm = this.baseForm + "este";
        this.elideFinalE = false;
    }

    public Adjective(String id, String baseform) {
        this(baseform);
        this.setID(id);
    }

    public Adjective(String id, String baseform, String citationform) {
        this(id, baseform);
        this.setCitationForm(citationform);
    }

    public Adjective(String posform, String compform, String supform, boolean elidefinal) {
        this(posform);
        this.comparativeForm = compform;
        this.superlativeForm = supform;
        this.elideFinalE = elidefinal;
    }

    public Adjective(String baseform, String posform, String compform, String supform, boolean elidefinal) {
        this(baseform);
        this.positiveForm = posform;
        this.comparativeForm = compform;
        this.superlativeForm = supform;
        this.elideFinalE = elidefinal;
    }

    public String getComparative() {
        return this.comparativeForm;
    }

    public void setComparative(String comp) {
        this.comparativeForm = comp;
    }

    public String getSuperlative() {
        return this.superlativeForm;
    }

    public void setSuperlative(String sup) {
        this.superlativeForm = sup;
    }

    public String getPositive() {
        return this.positiveForm;
    }

    public void setPositive(String pos) {
        this.positiveForm = pos;
    }

    public Collection<AdjectivePosition> getPositions() {
        return this.positions;
    }

    public void addPosition(AdjectivePosition position) {
        this.positions.add(position);
    }

    public void setPositions(Collection<AdjectivePosition> pos) {
        this.positions.clear();
        this.positions.addAll(pos);
    }

    public boolean hasPosition(AdjectivePosition position) {
        return this.positions.contains(position);
    }

    public AdjectiveType getType() {
        return this.type;
    }

    public void setType(AdjectiveType type) {
        this.type = type;
    }

    public boolean isElideFinalE() {
        return this.elideFinalE;
    }

    public void setElideFinalE(boolean elideFinalE) {
        this.elideFinalE = elideFinalE;
    }

    public String getForm(Case c, NumberAgr n, Gender g, AdjectiveType t, AdjectiveDegree d) {
        return AdjectiveInflection.getForm(this, c, n, g, t, d);
    }

    public boolean isStative() {
        return this.type == AdjectiveType.STATIVE;
    }

    public Noun castToNoun() {
        Noun n = new Noun(this.baseForm);
        n.setBaseAdjective(this);
        return n;
    }
}

