local export = {}

local data = {}

data["ug-Arab"] = {
	-- consonants
	["م"] = "m",  ["ن"] = "n",  ["د"] = "d",  ["ت"] = "t",
	["ب"] = "b",  ["پ"] = "p",  ["ف"] = "f",  ["ق"] = "q",
	["ك"] = "k",  ["ڭ"] = "ng", ["گ"] = "g",  ["غ"] = "gh",
	["ع"] = "ğ",  ["ھ"] = "h",  ["خ"] = "x",  ["چ"] = "ch",
	["ج"] = "j", ["ژ"] = "zh", ["ز"] = "z",  ["س"] = "s",
	["ش"] = "sh", ["ر"] = "r",  ["ل"] = "l",  ["ئ"] = "'",
	["ي"] = "y",  ["ۋ"] = "w",
	-- vowels
	["ا"] = "a", ["ە"] = "e", ["ې"] = "ë", ["ى"] = "i",
	["و"] = "o", ["ۆ"] = "ö", ["ۇ"] = "u", ["ۈ"] = "ü",
	-- punctuation
	["؟"]="?",
	["،"]=",",
	["؛"]=";"
}

data["Cyrl"] = {
	["А"] = "A", ["Б"] = "B", ["В"] = "W", ["Г"] = "G", ["Ғ"] = "Gh", ["Д"] = "D", ["Е"] = "Ë", ["Ә"] = "E", ["Ж"] = "Zh", ["Җ"] = "J",
	["З"] = "Z", ["И"] = "I", ["Й"] = "Y", ["К"] = "K", ["Қ"] = "Q", ["Л"] = "L", ["М"] = "M", ["Н"] = "N", ["Ң"] = "Ng", ["О"] = "O",
	["Ө"] = "Ö", ["П"] = "P", ["Р"] = "R", ["С"] = "S", ["Т"] = "T", ["У"] = "U", ["Ү"] = "Ü", ["Ф"] = "F", ["Х"] = "X", ["Һ"] = "H",
	["Ч"] = "Ch", ["Ш"] = "Sh", ["Ю"] = "Yu", ["Я"] = "Ya",
	["Э"] = "É",
	["а"] = "a", ["б"] = "b", ["в"] = "w", ["г"] = "g", ["ғ"] = "gh", ["д"] = "d", ["е"] = "ë", ["ә"] = "e", ["ж"] = "zh", ["җ"] = "j",
	["з"] = "z", ["и"] = "i", ["й"] = "y", ["к"] = "k", ["қ"] = "q", ["л"] = "l", ["м"] = "m", ["н"] = "n", ["ң"] = "ng", ["о"] = "o",
	["ө"] = "ö", ["п"] = "p", ["р"] = "r", ["с"] = "s", ["т"] = "t", ["у"] = "u", ["ү"] = "ü", ["ф"] = "f", ["х"] = "x", ["һ"] = "h",
	["ч"] = "ch", ["ш"] = "sh", ["ю"] = "yu", ["я"] = "ya",
	["э"] = "é",
}


function export.tr(text, lang, sc)
	if not data[sc] then
		return nil
	end
	
	-- remove initial hamza
	text = mw.ustring.gsub(text, "^\216\166(.)", "%1")
	text = mw.ustring.gsub(text, "%s\216\166(.)", " %1")
	
	-- transliterate letters one to one
	text = mw.ustring.gsub(text, ".", data[sc])
	
	return text
end

return export