/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.TypesafeMap;
import java.util.Map;
import java.util.Set;

public class HashableCoreMap
extends ArrayCoreMap {
    private final Set<Class<? extends TypesafeMap.Key<?>>> immutableKeys;
    private final int hashcode;
    private static final long serialVersionUID = 1L;

    public HashableCoreMap(Map<Class<? extends TypesafeMap.Key<?>>, Object> hashkey) {
        int keyHashcode = 0;
        int valueHashcode = 0;
        for (Map.Entry<Class<TypesafeMap.Key<?>>, Object> entry : hashkey.entrySet()) {
            keyHashcode += entry.getKey().hashCode();
            valueHashcode += entry.getValue().hashCode();
            super.set(entry.getKey(), entry.getValue());
        }
        this.immutableKeys = hashkey.keySet();
        this.hashcode = keyHashcode * 31 + valueHashcode;
    }

    public HashableCoreMap(ArrayCoreMap other, Set<Class<? extends TypesafeMap.Key<?>>> hashkey) {
        super(other);
        int keyHashcode = 0;
        int valueHashcode = 0;
        for (Class<TypesafeMap.Key<?>> key : hashkey) {
            keyHashcode += key.hashCode();
            valueHashcode += super.get(key).hashCode();
        }
        this.immutableKeys = hashkey;
        this.hashcode = keyHashcode * 31 + valueHashcode;
    }

    @Override
    public <VALUE> VALUE set(Class<? extends TypesafeMap.Key<VALUE>> key, VALUE value) {
        if (this.immutableKeys.contains(key)) {
            throw new HashableCoreMapException("Attempt to change value of immutable field " + key.getSimpleName());
        }
        return super.set(key, value);
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof HashableCoreMap) {
            HashableCoreMap other = (HashableCoreMap)o;
            if (!((Object)other.immutableKeys).equals(this.immutableKeys)) {
                return false;
            }
            for (Class<? extends TypesafeMap.Key<?>> clazz : this.immutableKeys) {
                if (this.get(clazz).equals(other.get(clazz))) continue;
                return false;
            }
            return true;
        }
        return super.equals(o);
    }

    public static class HashableCoreMapException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public HashableCoreMapException(String message) {
            super(message);
        }
    }
}

