/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph;

import edu.stanford.nlp.graph.DirectedMultiGraph;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.process.Morphology;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.SemanticGraphFormatter;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.trees.EnglishGrammaticalRelations;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringParsingTask;
import edu.stanford.nlp.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SemanticGraph
implements Serializable {
    public static boolean addSRLArcs = false;
    private static final SemanticGraphFormatter formatter = new SemanticGraphFormatter();
    private Collection<IndexedWord> roots;
    private DirectedMultiGraph<IndexedWord, SemanticGraphEdge> graph;
    private static final Pattern WORD_AND_INDEX_PATTERN = Pattern.compile("([^-]+)-([0-9]+)");
    private static final long serialVersionUID = 1L;

    public int edgeCount() {
        return this.graph.getNumEdges();
    }

    public int outDegree(IndexedWord vertex) {
        return this.graph.getOutDegree(vertex);
    }

    public int inDegree(IndexedWord vertex) {
        return this.graph.getInDegree(vertex);
    }

    public List<SemanticGraphEdge> getAllEdges(IndexedWord gov, IndexedWord dep) {
        return this.graph.getEdges(gov, dep);
    }

    public SemanticGraphEdge getEdge(IndexedWord gov, IndexedWord dep) {
        List<SemanticGraphEdge> edges = this.graph.getEdges(gov, dep);
        if (edges == null || edges.isEmpty()) {
            return null;
        }
        return edges.get(0);
    }

    public void addVertex(IndexedWord vertex) {
        this.graph.addVertex(vertex);
    }

    public boolean containsVertex(IndexedWord vertex) {
        return this.graph.containsVertex(vertex);
    }

    public boolean containsEdge(IndexedWord source, IndexedWord target) {
        return this.graph.isEdge(source, target);
    }

    public boolean containsEdge(SemanticGraphEdge edge) {
        return this.containsEdge(edge.getSource(), edge.getTarget());
    }

    public Set<IndexedWord> vertexSet() {
        return this.graph.getAllVertices();
    }

    public Set<SemanticGraphEdge> getEdgeSet() {
        Set<SemanticGraphEdge> edges = Generics.newHashSet();
        for (SemanticGraphEdge edge : this.edgeIterable()) {
            edges.add(edge);
        }
        return edges;
    }

    public boolean removeEdge(SemanticGraphEdge e) {
        return this.graph.removeEdge(e.getSource(), e.getTarget(), e);
    }

    public boolean removeVertex(IndexedWord vertex) {
        return this.graph.removeVertex(vertex);
    }

    public List<IndexedWord> vertexListSorted() {
        ArrayList<IndexedWord> vlist = new ArrayList<IndexedWord>(this.vertexSet());
        Collections.sort(vlist);
        return vlist;
    }

    public List<SemanticGraphEdge> edgeListSorted() {
        ArrayList<SemanticGraphEdge> edgeList = new ArrayList<SemanticGraphEdge>();
        for (SemanticGraphEdge edge : this.edgeIterable()) {
            edgeList.add(edge);
        }
        Collections.sort(edgeList, SemanticGraphEdge.orderByTargetComparator());
        return edgeList;
    }

    public Iterable<SemanticGraphEdge> edgeIterable() {
        return this.graph.edgeIterable();
    }

    public Iterable<SemanticGraphEdge> outgoingEdgeIterable(IndexedWord v) {
        return this.graph.outgoingEdgeIterable(v);
    }

    public Iterable<SemanticGraphEdge> incomingEdgeIterable(IndexedWord v) {
        return this.graph.incomingEdgeIterable(v);
    }

    public List<SemanticGraphEdge> outgoingEdgeList(IndexedWord v) {
        ArrayList<SemanticGraphEdge> edges = new ArrayList<SemanticGraphEdge>();
        for (SemanticGraphEdge edge : this.outgoingEdgeIterable(v)) {
            edges.add(edge);
        }
        return edges;
    }

    public List<SemanticGraphEdge> incomingEdgeList(IndexedWord v) {
        ArrayList<SemanticGraphEdge> edges = new ArrayList<SemanticGraphEdge>();
        for (SemanticGraphEdge edge : this.incomingEdgeIterable(v)) {
            edges.add(edge);
        }
        return edges;
    }

    public boolean isEmpty() {
        return this.graph.isEmpty();
    }

    public int isAncestor(IndexedWord child, IndexedWord ancestor) {
        List<IndexedWord> parents = this.getParentList(child);
        if (parents == null) {
            return -1;
        }
        if (parents.contains(ancestor)) {
            return 1;
        }
        for (IndexedWord parent : parents) {
            List<IndexedWord> grandparents = this.getParentList(parent);
            if (!grandparents.contains(ancestor)) continue;
            return 2;
        }
        return -1;
    }

    public int commonAncestor(IndexedWord v1, IndexedWord v2) {
        List<IndexedWord> v1Parents = this.getParentList(v1);
        List<IndexedWord> v2Parents = this.getParentList(v2);
        ArrayList<IndexedWord> v1GrandParents = new ArrayList<IndexedWord>();
        ArrayList<IndexedWord> v2GrandParents = new ArrayList<IndexedWord>();
        for (IndexedWord v1Parent : v1Parents) {
            if (v2Parents.contains(v1Parent)) {
                return 1;
            }
            v1GrandParents.addAll(this.getParentList(v1Parent));
        }
        for (IndexedWord v1GrandParent : v1GrandParents) {
            if (!v2Parents.contains(v1GrandParent)) continue;
            return 2;
        }
        for (IndexedWord v2Parent : v2Parents) {
            v2GrandParents.addAll(this.getParentList(v2Parent));
        }
        for (IndexedWord v2GrandParent : v2GrandParents) {
            if (v1Parents.contains(v2GrandParent)) {
                return 1;
            }
            if (!v1GrandParents.contains(v2GrandParent)) continue;
            return 2;
        }
        return -1;
    }

    public IndexedWord getCommonAncestor(IndexedWord v1, IndexedWord v2) {
        if (this.isAncestor(v1, v2) >= 1) {
            return v2;
        }
        if (this.isAncestor(v2, v1) >= 1) {
            return v1;
        }
        List<IndexedWord> v1Parents = this.getParentList(v1);
        List<IndexedWord> v2Parents = this.getParentList(v2);
        ArrayList<IndexedWord> v1GrandParents = new ArrayList<IndexedWord>();
        ArrayList<IndexedWord> v2GrandParents = new ArrayList<IndexedWord>();
        for (IndexedWord v1Parent : v1Parents) {
            if (v2Parents.contains(v1Parent)) {
                return v1Parent;
            }
            v1GrandParents.addAll(this.getParentList(v1Parent));
        }
        for (IndexedWord v1GrandParent : v1GrandParents) {
            if (!v2Parents.contains(v1GrandParent)) continue;
            return v1GrandParent;
        }
        for (IndexedWord v2Parent : v2Parents) {
            v2GrandParents.addAll(this.getParentList(v2Parent));
        }
        for (IndexedWord v2GrandParent : v2GrandParents) {
            if (v1Parents.contains(v2GrandParent)) {
                return v2GrandParent;
            }
            if (!v1GrandParents.contains(v2GrandParent)) continue;
            return v2GrandParent;
        }
        return null;
    }

    public boolean matchPatternToVertex(String pattern, IndexedWord vertex, boolean det) {
        String[] nodePath;
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        String pat = pattern.replaceAll("<", ",<");
        pat = pat.replaceAll(">", ",>");
        for (String s : nodePath = pat.split(",")) {
            String lemma;
            boolean match;
            if (s.equals("")) continue;
            String word = s.substring(1);
            char dir = s.charAt(0);
            if (dir == '<') {
                List<IndexedWord> parents = this.getParentList(vertex);
                match = false;
                for (IndexedWord indexedWord : parents) {
                    lemma = (String)indexedWord.get(CoreAnnotations.LemmaAnnotation.class);
                    if (!lemma.equals(word)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
            if (dir == '>') {
                List children;
                if (det) {
                    children = this.getChildrenWithReln(vertex, EnglishGrammaticalRelations.DETERMINER);
                    children.addAll(this.getChildrenWithReln(vertex, EnglishGrammaticalRelations.PREDETERMINER));
                    match = false;
                    for (IndexedWord indexedWord : children) {
                        lemma = (String)indexedWord.get(CoreAnnotations.LemmaAnnotation.class);
                        if (lemma.equals("")) {
                            lemma = indexedWord.word().toLowerCase();
                        }
                        if (!lemma.equals(word)) continue;
                        match = true;
                        break;
                    }
                    if (match) continue;
                    return false;
                }
                children = this.childPairs(vertex);
                match = false;
                for (Pair pair : children) {
                    if (((GrammaticalRelation)pair.first()).toString().equals("det")) continue;
                    IndexedWord child = (IndexedWord)pair.second();
                    String lemma2 = (String)child.get(CoreAnnotations.LemmaAnnotation.class);
                    if (lemma2.equals("")) {
                        lemma2 = child.word().toLowerCase();
                    }
                    if (!lemma2.equals(word)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
            throw new RuntimeException("Warning: bad pattern \"%s\"\n" + pattern);
        }
        return true;
    }

    public boolean matchPatternToVertex(String pattern, IndexedWord vertex) {
        String[] nodePath;
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        String pat = pattern.replaceAll("<", ",<");
        pat = pat.replaceAll(">", ",>");
        for (String s : nodePath = pat.split(",")) {
            String lemma;
            boolean match;
            if (s.equals("")) continue;
            String word = s.substring(1);
            char dir = s.charAt(0);
            if (dir == '<') {
                List<IndexedWord> parents = this.getParentList(vertex);
                match = false;
                for (IndexedWord parent : parents) {
                    lemma = (String)parent.get(CoreAnnotations.LemmaAnnotation.class);
                    if (!lemma.equals(word)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
            if (dir == '>') {
                List<IndexedWord> children = this.getChildList(vertex);
                match = false;
                for (IndexedWord child : children) {
                    lemma = (String)child.get(CoreAnnotations.LemmaAnnotation.class);
                    if (lemma == null || lemma.equals("")) {
                        lemma = child.word().toLowerCase();
                    }
                    if (!lemma.equals(word)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
            throw new RuntimeException("Warning: bad pattern \"%s\"\n" + pattern);
        }
        return true;
    }

    public List<IndexedWord> getChildList(IndexedWord vertex) {
        if (!this.vertexSet().contains(vertex)) {
            System.err.println("Weird vertex: Index " + vertex.index() + ", word " + vertex.word());
            System.err.println("Vertices I know: " + this.vertexSet());
            throw new IllegalArgumentException();
        }
        ArrayList<IndexedWord> result = new ArrayList<IndexedWord>(this.getChildren(vertex));
        Collections.sort(result);
        return result;
    }

    public Collection<IndexedWord> getChildren(IndexedWord vertex) {
        ArrayList<IndexedWord> result = new ArrayList<IndexedWord>();
        for (SemanticGraphEdge edge : this.outgoingEdgeIterable(vertex)) {
            IndexedWord child = edge.getTarget();
            result.add(child);
        }
        return result;
    }

    public boolean hasChildren(IndexedWord vertex) {
        Iterator<SemanticGraphEdge> i$ = this.outgoingEdgeIterable(vertex).iterator();
        if (i$.hasNext()) {
            SemanticGraphEdge edge = i$.next();
            return true;
        }
        return false;
    }

    public List<SemanticGraphEdge> getIncomingEdgesSorted(IndexedWord vertex) {
        List<SemanticGraphEdge> edges = this.incomingEdgeList(vertex);
        Collections.sort(edges);
        return edges;
    }

    public List<SemanticGraphEdge> getOutEdgesSorted(IndexedWord vertex) {
        List<SemanticGraphEdge> edges = this.outgoingEdgeList(vertex);
        Collections.sort(edges);
        return edges;
    }

    public List<IndexedWord> getParentList(IndexedWord vertex) {
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        ArrayList<IndexedWord> result = new ArrayList<IndexedWord>(this.getParents(vertex));
        Collections.sort(result);
        return result;
    }

    public Collection<IndexedWord> getParents(IndexedWord vertex) {
        ArrayList<IndexedWord> result = new ArrayList<IndexedWord>();
        for (SemanticGraphEdge edge : this.incomingEdgeIterable(vertex)) {
            IndexedWord parent = edge.getSource();
            result.add(parent);
        }
        return result;
    }

    public Collection<IndexedWord> getSiblings(IndexedWord vertex) {
        IndexedWord parent = this.getParent(vertex);
        if (parent != null) {
            List<IndexedWord> result = this.getChildList(parent);
            result.remove(vertex);
            return result;
        }
        return new ArrayList<IndexedWord>();
    }

    private List<IndexedWord> getPathToRoot(IndexedWord vertex, List<IndexedWord> used) {
        used.add(vertex);
        List<IndexedWord> parents = this.getParentList(vertex);
        parents.removeAll(used);
        if (this.roots.contains(vertex) || parents.size() == 0) {
            used.remove(used.size() - 1);
            if (this.roots.contains(vertex)) {
                return new Vector<IndexedWord>();
            }
            return null;
        }
        for (IndexedWord parent : parents) {
            List<IndexedWord> path = this.getPathToRoot(parent, used);
            if (path == null) continue;
            path.add(0, parent);
            used.remove(used.size() - 1);
            return path;
        }
        used.remove(used.size() - 1);
        return null;
    }

    public List<IndexedWord> getPathToRoot(IndexedWord vertex) {
        return this.getPathToRoot(vertex, new Vector<IndexedWord>());
    }

    public IndexedWord getParent(IndexedWord vertex) {
        List<IndexedWord> path = this.getPathToRoot(vertex);
        if (path != null && path.size() > 0) {
            return path.get(0);
        }
        return null;
    }

    public IndexedWord getNodeByIndex(int index) throws IllegalArgumentException {
        IndexedWord node = this.getNodeByIndexSafe(index);
        if (node == null) {
            throw new IllegalArgumentException("No SemanticGraph vertex with index " + index);
        }
        return node;
    }

    public IndexedWord getNodeByIndexSafe(int index) {
        for (IndexedWord vertex : this.vertexSet()) {
            if (vertex.index() != index) continue;
            return vertex;
        }
        return null;
    }

    public IndexedWord getNodeByWordPattern(String pattern) {
        Pattern p = Pattern.compile(pattern);
        for (IndexedWord vertex : this.vertexSet()) {
            String w = vertex.word();
            if ((w != null || pattern != null) && (w == null || !p.matcher(w).matches())) continue;
            return vertex;
        }
        return null;
    }

    public List<IndexedWord> getAllNodesByWordPattern(String pattern) {
        Pattern p = Pattern.compile(pattern);
        ArrayList<IndexedWord> nodes = new ArrayList<IndexedWord>();
        for (IndexedWord vertex : this.vertexSet()) {
            String w = vertex.word();
            if ((w != null || pattern != null) && (w == null || !p.matcher(w).matches())) continue;
            nodes.add(vertex);
        }
        return nodes;
    }

    public Set<IndexedWord> descendants(IndexedWord vertex) {
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        Set<IndexedWord> descendantSet = Generics.newHashSet();
        this.descendantsHelper(vertex, descendantSet);
        return descendantSet;
    }

    private void descendantsHelper(IndexedWord curr, Set<IndexedWord> descendantSet) {
        if (descendantSet.contains(curr)) {
            return;
        }
        descendantSet.add(curr);
        for (IndexedWord child : this.getChildList(curr)) {
            this.descendantsHelper(child, descendantSet);
        }
    }

    public List<Pair<GrammaticalRelation, IndexedWord>> childPairs(IndexedWord vertex) {
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        ArrayList<Pair<GrammaticalRelation, IndexedWord>> childPairs = Generics.newArrayList();
        for (SemanticGraphEdge e : this.outgoingEdgeIterable(vertex)) {
            childPairs.add(new Pair<GrammaticalRelation, IndexedWord>(e.getRelation(), e.getTarget()));
        }
        return childPairs;
    }

    public List<Pair<GrammaticalRelation, IndexedWord>> parentPairs(IndexedWord vertex) {
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        ArrayList<Pair<GrammaticalRelation, IndexedWord>> parentPairs = Generics.newArrayList();
        for (SemanticGraphEdge e : this.incomingEdgeIterable(vertex)) {
            parentPairs.add(new Pair<GrammaticalRelation, IndexedWord>(e.getRelation(), e.getSource()));
        }
        return parentPairs;
    }

    public Set<GrammaticalRelation> relns(IndexedWord vertex) {
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        Set<GrammaticalRelation> relns = Generics.newHashSet();
        List<Pair<GrammaticalRelation, IndexedWord>> pairs = this.parentPairs(vertex);
        for (Pair<GrammaticalRelation, IndexedWord> p : pairs) {
            relns.add(p.first());
        }
        return relns;
    }

    public GrammaticalRelation reln(IndexedWord a, IndexedWord b) {
        if (!this.vertexSet().contains(a)) {
            throw new IllegalArgumentException();
        }
        List<Pair<GrammaticalRelation, IndexedWord>> pairs = this.childPairs(a);
        for (Pair<GrammaticalRelation, IndexedWord> p : pairs) {
            if (!p.second().equals(b)) continue;
            return p.first();
        }
        return null;
    }

    public Set<GrammaticalRelation> childRelns(IndexedWord vertex) {
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        Set<GrammaticalRelation> relns = Generics.newHashSet();
        List<Pair<GrammaticalRelation, IndexedWord>> pairs = this.childPairs(vertex);
        for (Pair<GrammaticalRelation, IndexedWord> p : pairs) {
            relns.add(p.first());
        }
        return relns;
    }

    public Collection<IndexedWord> getRoots() {
        return this.roots;
    }

    private List<IndexedWord> getVerticesWithoutParents() {
        ArrayList<IndexedWord> result = new ArrayList<IndexedWord>();
        for (IndexedWord v : this.vertexSet()) {
            int inDegree = this.inDegree(v);
            if (inDegree != 0) continue;
            result.add(v);
        }
        Collections.sort(result);
        return result;
    }

    public IndexedWord getFirstRoot() {
        if (this.roots.isEmpty()) {
            throw new RuntimeException("No roots in graph:\n" + this + "\nFind where this graph was created and make sure you're adding roots.");
        }
        return this.roots.iterator().next();
    }

    public void addRoot(IndexedWord root) {
        this.addVertex(root);
        this.roots.add(root);
    }

    public void resetRoots() {
        List<IndexedWord> newRoots = this.getVerticesWithoutParents();
        if (newRoots.size() > 0) {
            this.roots.clear();
            this.roots.addAll(newRoots);
            return;
        }
        ClassicCounter<Pair<IndexedWord, IndexedWord>> nodeDists = new ClassicCounter<Pair<IndexedWord, IndexedWord>>();
        TreeSet<IndexedWord> nodes = new TreeSet<IndexedWord>(this.vertexSet());
        for (IndexedWord node1 : nodes) {
            for (IndexedWord node2 : nodes) {
                Pair<IndexedWord, IndexedWord> key = new Pair<IndexedWord, IndexedWord>(node1, node2);
                List<SemanticGraphEdge> path = this.getShortestDirectedPathEdges(node1, node2);
                if (path == null) continue;
                int dist = path.size();
                nodeDists.setCount(key, dist);
            }
        }
        ClassicCounter<IndexedWord> dominatedEdgeCount = new ClassicCounter<IndexedWord>();
        TreeSet<IndexedWord> nodesList = new TreeSet<IndexedWord>(this.vertexSet());
        for (IndexedWord outer : nodesList) {
            for (IndexedWord inner : nodesList) {
                Pair<IndexedWord, IndexedWord> key = new Pair<IndexedWord, IndexedWord>(outer, inner);
                dominatedEdgeCount.incrementCount(outer, nodeDists.getCount(key));
            }
        }
        IndexedWord winner = (IndexedWord)Counters.argmax(dominatedEdgeCount);
        this.setRoot(winner);
    }

    public void setRoot(IndexedWord word) {
        this.roots.clear();
        this.roots.add(word);
    }

    public void setRoots(Collection<IndexedWord> words) {
        this.roots.clear();
        this.roots.addAll(words);
    }

    public List<IndexedWord> topologicalSort() throws IllegalStateException {
        LinkedList<IndexedWord> q = new LinkedList<IndexedWord>(this.getVerticesWithoutParents());
        Set<SemanticGraphEdge> remainingEdges = this.getEdgeSet();
        ArrayList<IndexedWord> result = new ArrayList<IndexedWord>();
        while (!q.isEmpty()) {
            IndexedWord node = q.removeLast();
            result.add(node);
            for (SemanticGraphEdge e : this.outgoingEdgeIterable(node)) {
                IndexedWord target = e.getTarget();
                remainingEdges.remove(e);
                boolean hasInbound = false;
                for (SemanticGraphEdge other : this.incomingEdgeIterable(target)) {
                    if (!remainingEdges.contains(other)) continue;
                    hasInbound = true;
                    break;
                }
                if (hasInbound) continue;
                q.addLast(target);
            }
        }
        if (result.size() != this.vertexSet().size()) {
            throw new IllegalStateException("This graph has cycles. Topological sort not possible: " + result);
        }
        return result;
    }

    public boolean hasChild(IndexedWord vertex, GrammaticalRelation reln, String childLemma) {
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        for (SemanticGraphEdge edge : this.outgoingEdgeIterable(vertex)) {
            if (!edge.getRelation().equals(reln) || !((String)edge.getTarget().get(CoreAnnotations.LemmaAnnotation.class)).equals(childLemma)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildWithReln(IndexedWord vertex, GrammaticalRelation reln) {
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        for (SemanticGraphEdge edge : this.outgoingEdgeIterable(vertex)) {
            if (!edge.getRelation().equals(reln)) continue;
            return true;
        }
        return false;
    }

    public boolean hasParentWithReln(IndexedWord vertex, GrammaticalRelation reln) {
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        for (SemanticGraphEdge edge : this.incomingEdgeIterable(vertex)) {
            if (!edge.getRelation().equals(reln)) continue;
            return true;
        }
        return false;
    }

    public IndexedWord getChildWithReln(IndexedWord vertex, GrammaticalRelation reln) {
        if (vertex.equals(IndexedWord.NO_WORD)) {
            return null;
        }
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        for (SemanticGraphEdge edge : this.outgoingEdgeIterable(vertex)) {
            if (!edge.getRelation().equals(reln)) continue;
            return edge.getTarget();
        }
        return null;
    }

    public List<IndexedWord> getParentsWithReln(IndexedWord vertex, GrammaticalRelation reln) {
        if (vertex.equals(IndexedWord.NO_WORD)) {
            return new ArrayList<IndexedWord>();
        }
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        ArrayList<IndexedWord> parentList = Generics.newArrayList();
        for (SemanticGraphEdge edge : this.incomingEdgeIterable(vertex)) {
            if (!edge.getRelation().equals(reln)) continue;
            parentList.add(edge.getSource());
        }
        return parentList;
    }

    public List<IndexedWord> getChildrenWithReln(IndexedWord vertex, GrammaticalRelation reln) {
        if (vertex.equals(IndexedWord.NO_WORD)) {
            return new ArrayList<IndexedWord>();
        }
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        ArrayList<IndexedWord> childList = Generics.newArrayList();
        for (SemanticGraphEdge edge : this.outgoingEdgeIterable(vertex)) {
            if (!edge.getRelation().equals(reln)) continue;
            childList.add(edge.getTarget());
        }
        return childList;
    }

    public List<IndexedWord> getChildrenWithRelns(IndexedWord vertex, Collection<GrammaticalRelation> relns) {
        if (vertex.equals(IndexedWord.NO_WORD)) {
            return new ArrayList<IndexedWord>();
        }
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        ArrayList<IndexedWord> childList = new ArrayList<IndexedWord>();
        for (SemanticGraphEdge edge : this.outgoingEdgeIterable(vertex)) {
            if (!relns.contains(edge.getRelation())) continue;
            childList.add(edge.getTarget());
        }
        return childList;
    }

    public SemanticGraphEdge getEdge(IndexedWord gov, IndexedWord dep, GrammaticalRelation reln) {
        List<SemanticGraphEdge> edges = this.getAllEdges(gov, dep);
        if (edges != null) {
            for (SemanticGraphEdge edge : edges) {
                if (!edge.getSource().equals(gov) || !edge.getRelation().equals(reln)) continue;
                return edge;
            }
        }
        return null;
    }

    public boolean isNegatedVertex(IndexedWord vertex) {
        if (vertex == IndexedWord.NO_WORD) {
            return false;
        }
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException("Vertex " + vertex + " not in graph " + this);
        }
        return this.hasChildWithReln(vertex, EnglishGrammaticalRelations.NEGATION_MODIFIER) || this.hasChild(vertex, GrammaticalRelation.DEPENDENT, "nor");
    }

    private boolean isNegatedVerb(IndexedWord vertex) {
        if (!this.vertexSet().contains(vertex)) {
            throw new IllegalArgumentException();
        }
        return vertex.tag().startsWith("VB") && this.isNegatedVertex(vertex);
    }

    public boolean isInConditionalContext(IndexedWord vertex) {
        List<IndexedWord> children = this.getChildrenWithReln(vertex, EnglishGrammaticalRelations.MARKER);
        for (IndexedWord child : children) {
            if (!child.word().equalsIgnoreCase("if")) continue;
            return true;
        }
        return false;
    }

    public boolean attachedNegatedVerb(IndexedWord vertex) {
        for (IndexedWord parent : this.getParentList(vertex)) {
            if (!this.isNegatedVerb(parent)) continue;
            return true;
        }
        return false;
    }

    public boolean isAuxiliaryVerb(IndexedWord vertex) {
        Set<GrammaticalRelation> relns = this.relns(vertex);
        if (relns.isEmpty()) {
            return false;
        }
        boolean result = relns.contains(EnglishGrammaticalRelations.AUX_MODIFIER) || relns.contains(EnglishGrammaticalRelations.AUX_PASSIVE_MODIFIER);
        return result;
    }

    public Set<IndexedWord> getLeafVertices() {
        Set<IndexedWord> result = Generics.newHashSet();
        Set<IndexedWord> vertices = this.vertexSet();
        for (IndexedWord v : vertices) {
            if (this.outDegree(v) != 0) continue;
            result.add(v);
        }
        return result;
    }

    public int size() {
        return this.vertexSet().size();
    }

    public boolean isDag() {
        Set<IndexedWord> unused = Generics.newHashSet(this.vertexSet());
        while (!unused.isEmpty()) {
            IndexedWord arbitrary = unused.iterator().next();
            boolean result = this.isDagHelper(arbitrary, unused, Generics.<IndexedWord>newHashSet());
            if (!result) continue;
            return false;
        }
        return true;
    }

    private boolean isDagHelper(IndexedWord current, Set<IndexedWord> unused, Set<IndexedWord> trail) {
        if (trail.contains(current)) {
            return true;
        }
        if (!unused.contains(current)) {
            return false;
        }
        unused.remove(current);
        trail.add(current);
        for (IndexedWord child : this.getChildList(current)) {
            boolean result = this.isDagHelper(child, unused, trail);
            if (!result) continue;
            return true;
        }
        trail.remove(current);
        return false;
    }

    private void insertSpecificIntoList(String specific, IndexedWord relnTgtNode, List<IndexedWord> tgtList) {
        int currIndex;
        Set<IndexedWord> descendents = this.descendants(relnTgtNode);
        IndexedWord specificNode = new IndexedWord();
        specificNode.set(CoreAnnotations.LemmaAnnotation.class, specific);
        specificNode.set(CoreAnnotations.TextAnnotation.class, specific);
        specificNode.set(CoreAnnotations.OriginalTextAnnotation.class, specific);
        for (currIndex = tgtList.indexOf(relnTgtNode); currIndex >= 1 && descendents.contains(tgtList.get(currIndex - 1)); --currIndex) {
        }
        tgtList.add(currIndex, specificNode);
    }

    public String toString() {
        Collection<IndexedWord> rootNodes = this.getRoots();
        if (rootNodes.isEmpty()) {
            return this.toString("readable");
        }
        StringBuilder sb = new StringBuilder();
        Set<IndexedWord> used = Generics.newHashSet();
        for (IndexedWord root : rootNodes) {
            sb.append("-> ").append(root).append(" (root)\n");
            this.recToString(root, sb, 1, used);
        }
        Set<IndexedWord> nodes = Generics.newHashSet(this.vertexSet());
        nodes.removeAll(used);
        while (!nodes.isEmpty()) {
            IndexedWord node = nodes.iterator().next();
            sb.append(node).append("\n");
            this.recToString(node, sb, 1, used);
            nodes.removeAll(used);
        }
        return sb.toString();
    }

    private void recToString(IndexedWord curr, StringBuilder sb, int offset, Set<IndexedWord> used) {
        used.add(curr);
        List<SemanticGraphEdge> edges = this.outgoingEdgeList(curr);
        Collections.sort(edges);
        for (SemanticGraphEdge edge : edges) {
            IndexedWord target = edge.getTarget();
            sb.append(SemanticGraph.space(2 * offset)).append("-> ").append(target).append(" (").append(edge.getRelation()).append(")\n");
            if (used.contains(target)) continue;
            this.recToString(target, sb, offset + 1, used);
        }
    }

    private static String space(int width) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < width; ++i) {
            b.append(' ');
        }
        return b.toString();
    }

    public String toRecoveredSentenceString() {
        StringBuilder sb = new StringBuilder();
        boolean pastFirst = false;
        for (IndexedWord word : this.vertexListSorted()) {
            if (pastFirst) {
                sb.append(' ');
            }
            pastFirst = true;
            sb.append(word.word());
        }
        return sb.toString();
    }

    public String toRecoveredSentenceStringWithIndexMarking() {
        StringBuilder sb = new StringBuilder();
        boolean pastFirst = false;
        int index = 0;
        for (IndexedWord word : this.vertexListSorted()) {
            if (pastFirst) {
                sb.append(' ');
            }
            pastFirst = true;
            sb.append(word.word());
            sb.append("(");
            sb.append(index++);
            sb.append(")");
        }
        return sb.toString();
    }

    public String toEnUncollapsedSentenceString() {
        LinkedList<IndexedWord> uncompressedList = Generics.newLinkedList(this.vertexSet());
        ArrayList<Pair<String, IndexedWord>> specifics = Generics.newArrayList();
        for (IndexedWord indexedWord : this.vertexSet()) {
            for (SemanticGraphEdge edge : this.getIncomingEdgesSorted(indexedWord)) {
                GrammaticalRelation relation = edge.getRelation();
                String specific = relation.getSpecific();
                if (specific == null && edge.getRelation().equals(EnglishGrammaticalRelations.AGENT)) {
                    specific = "by";
                }
                if (specific == null) continue;
                Pair<String, IndexedWord> specPair = new Pair<String, IndexedWord>(specific, indexedWord);
                specifics.add(specPair);
            }
        }
        for (Pair pair : specifics) {
            this.insertSpecificIntoList((String)pair.first(), (IndexedWord)pair.second(), uncompressedList);
        }
        return StringUtils.join(uncompressedList, " ");
    }

    public String toString(String format) {
        if (format != null && format.equals("xml")) {
            return this.toXMLString();
        }
        if (format != null && format.equals("readable")) {
            return this.toReadableString();
        }
        return this.toList();
    }

    public String toList() {
        StringBuilder buf = new StringBuilder();
        for (IndexedWord root : this.getRoots()) {
            buf.append("root(ROOT-0, ");
            buf.append(SemanticGraph.toDepStyle(root)).append(")\n");
        }
        for (SemanticGraphEdge edge : this.edgeListSorted()) {
            buf.append(edge.getRelation().toString()).append("(");
            buf.append(SemanticGraph.toDepStyle(edge.getSource())).append(", ");
            buf.append(SemanticGraph.toDepStyle(edge.getTarget())).append(")\n");
        }
        return buf.toString();
    }

    public String toPOSList() {
        StringBuilder buf = new StringBuilder();
        for (SemanticGraphEdge edge : this.edgeListSorted()) {
            buf.append(edge.getRelation().toString()).append("(");
            buf.append(SemanticGraph.toPOSStyle(edge.getSource())).append(",");
            buf.append(SemanticGraph.toPOSStyle(edge.getTarget())).append(")\n");
        }
        return buf.toString();
    }

    private static String toDepStyle(IndexedWord fl) {
        StringBuilder buf = new StringBuilder();
        buf.append(fl.word());
        buf.append("-");
        buf.append(fl.index());
        return buf.toString();
    }

    private static String toPOSStyle(IndexedWord fl) {
        StringBuilder buf = new StringBuilder();
        buf.append(fl.word());
        buf.append("/");
        buf.append(fl.tag());
        buf.append("-");
        buf.append(fl.index());
        return buf.toString();
    }

    private String toReadableString() {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("%-20s%-20s%-20s%n", "dep", "reln", "gov"));
        buf.append(String.format("%-20s%-20s%-20s%n", "---", "----", "---"));
        for (IndexedWord root : this.getRoots()) {
            buf.append(String.format("%-20s%-20s%-20s%n", SemanticGraph.toDepStyle(root), "root", "root"));
        }
        for (SemanticGraphEdge edge : this.edgeListSorted()) {
            buf.append(String.format("%-20s%-20s%-20s%n", SemanticGraph.toDepStyle(edge.getTarget()), edge.getRelation().toString(), SemanticGraph.toDepStyle(edge.getSource())));
        }
        return buf.toString();
    }

    private String toXMLString() {
        StringBuilder buf = new StringBuilder("<dependencies style=\"typed\">\n");
        for (SemanticGraphEdge edge : this.edgeListSorted()) {
            String reln = edge.getRelation().toString();
            String gov = edge.getSource().word();
            int govIdx = edge.getSource().index();
            String dep = edge.getTarget().word();
            int depIdx = edge.getTarget().index();
            buf.append("  <dep type=\"").append(reln).append("\">\n");
            buf.append("    <governor idx=\"").append(govIdx).append("\">").append(gov).append("</governor>\n");
            buf.append("    <dependent idx=\"").append(depIdx).append("\">").append(dep).append("</dependent>\n");
            buf.append("  </dep>\n");
        }
        buf.append("</dependencies>\n");
        return buf.toString();
    }

    public String toCompactString() {
        return this.toCompactString(false);
    }

    public String toCompactString(boolean showTags) {
        StringBuilder sb = new StringBuilder();
        Set<IndexedWord> used = Generics.newHashSet();
        Collection<IndexedWord> roots = this.getRoots();
        if (roots.isEmpty()) {
            if (this.size() == 0) {
                return "[EMPTY_SEMANTIC_GRAPH]";
            }
            return "[UNROOTED_SEMANTIC_GRAPH]";
        }
        for (IndexedWord root : roots) {
            this.toCompactStringHelper(root, sb, used, showTags);
        }
        return sb.toString();
    }

    private void toCompactStringHelper(IndexedWord node, StringBuilder sb, Set<IndexedWord> used, boolean showTags) {
        used.add(node);
        try {
            boolean isntLeaf;
            boolean bl = isntLeaf = this.outDegree(node) > 0;
            if (isntLeaf) {
                sb.append("[");
            }
            sb.append(node.word());
            if (showTags) {
                sb.append("/");
                sb.append(node.tag());
            }
            for (SemanticGraphEdge edge : this.getOutEdgesSorted(node)) {
                IndexedWord target = edge.getTarget();
                sb.append(" ").append(edge.getRelation()).append(":");
                if (!used.contains(target)) {
                    this.toCompactStringHelper(target, sb, used, showTags);
                    continue;
                }
                sb.append(target.word());
                if (!showTags) continue;
                sb.append("/");
                sb.append(target.tag());
            }
            if (isntLeaf) {
                sb.append("]");
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println("WHOA!  SemanticGraph.toCompactStringHelper() ran into problems at node " + node);
            throw new IllegalArgumentException(e);
        }
    }

    public String toFormattedString() {
        return formatter.formatSemanticGraph(this);
    }

    public String toFormattedString(SemanticGraphFormatter formatter) {
        return formatter.formatSemanticGraph(this);
    }

    public void prettyPrint(SemanticGraphFormatter formatter) {
        System.out.println(formatter.formatSemanticGraph(this));
    }

    public void prettyPrint() {
        System.out.println(formatter.formatSemanticGraph(this));
    }

    public String toDotFormat() {
        return this.toDotFormat("");
    }

    public String toDotFormat(String graphname) {
        return this.toDotFormat(graphname, "WORD_TAG_INDEX_FORMAT");
    }

    public String toDotFormat(String graphname, String indexedWordFormat) {
        StringBuilder output = new StringBuilder();
        output.append("digraph " + graphname + " {\n");
        for (IndexedWord word : this.graph.getAllVertices()) {
            output.append("  N_" + word.index() + " [label=\"" + word.toString(indexedWordFormat) + "\"];\n");
        }
        for (SemanticGraphEdge edge : this.graph.edgeIterable()) {
            output.append("  N_" + edge.getSource().index() + " -> N_" + edge.getTarget().index() + " [label=\"" + edge.getRelation() + "\"];\n");
        }
        output.append("}\n");
        return output.toString();
    }

    public SemanticGraphEdge addEdge(IndexedWord s, IndexedWord d, GrammaticalRelation reln, double weight, boolean isExtra) {
        SemanticGraphEdge newEdge = new SemanticGraphEdge(s, d, reln, weight, isExtra);
        this.graph.add(s, d, newEdge);
        return newEdge;
    }

    public static SemanticGraph valueOf(String s) {
        return new SemanticGraphParsingTask(s).parse();
    }

    public SemanticGraph() {
        this.graph = new DirectedMultiGraph();
        this.roots = Generics.newHashSet();
    }

    public SemanticGraph(SemanticGraph g) {
        this.graph = new DirectedMultiGraph();
        ArrayList<IndexedWord> oldRoots = new ArrayList<IndexedWord>(g.getRoots());
        Set<IndexedWord> vertexes = g.vertexSet();
        Map<IndexedWord, IndexedWord> prevToNewMap = Generics.newHashMap();
        for (IndexedWord vertex : vertexes) {
            IndexedWord newVertex = new IndexedWord(vertex);
            this.addVertex(newVertex);
            prevToNewMap.put(vertex, newVertex);
        }
        this.roots = Generics.newHashSet();
        for (IndexedWord oldRoot : oldRoots) {
            this.roots.add((IndexedWord)prevToNewMap.get(oldRoot));
        }
        for (SemanticGraphEdge edge : g.edgeIterable()) {
            IndexedWord newGov = (IndexedWord)prevToNewMap.get(edge.getGovernor());
            IndexedWord newDep = (IndexedWord)prevToNewMap.get(edge.getDependent());
            this.addEdge(newGov, newDep, edge.getRelation(), edge.getWeight(), edge.isExtra());
        }
    }

    public SemanticGraph(SemanticGraph g, Map<IndexedWord, IndexedWord> prevToNewMap) {
        this.graph = new DirectedMultiGraph();
        ArrayList<IndexedWord> oldRoots = new ArrayList<IndexedWord>(g.getRoots());
        if (prevToNewMap == null) {
            prevToNewMap = Generics.newHashMap();
        }
        Set<IndexedWord> vertexes = g.vertexSet();
        for (IndexedWord vertex : vertexes) {
            IndexedWord newVertex = new IndexedWord(vertex);
            this.addVertex(newVertex);
            prevToNewMap.put(vertex, newVertex);
        }
        this.roots = Generics.newHashSet();
        for (IndexedWord oldRoot : oldRoots) {
            this.roots.add(prevToNewMap.get(oldRoot));
        }
        for (SemanticGraphEdge edge : g.edgeIterable()) {
            IndexedWord newGov = prevToNewMap.get(edge.getGovernor());
            IndexedWord newDep = prevToNewMap.get(edge.getDependent());
            this.addEdge(newGov, newDep, edge.getRelation(), edge.getWeight(), edge.isExtra());
        }
    }

    public SemanticGraph(Collection<TypedDependency> dependencies) {
        this(dependencies, "", 0);
    }

    public SemanticGraph(Collection<TypedDependency> dependencies, String docID, int sentIndex) {
        this(dependencies, docID, sentIndex, false);
    }

    public SemanticGraph(Collection<TypedDependency> dependencies, String docID, int sentIndex, boolean lemmatize) {
        Morphology morphology = lemmatize ? new Morphology() : null;
        this.graph = new DirectedMultiGraph();
        this.roots = Generics.newHashSet();
        for (TypedDependency d : dependencies) {
            TreeGraphNode gov = d.gov();
            TreeGraphNode dep = d.dep();
            GrammaticalRelation reln = d.reln();
            CoreLabel govLabel = new CoreLabel(gov.label());
            CoreLabel depLabel = new CoreLabel(dep.label());
            if (reln != GrammaticalRelation.ROOT) {
                IndexedWord govVertex = new IndexedWord(docID, sentIndex, gov.index(), govLabel);
                govVertex.setTag(gov.highestNodeWithSameHead().headTagNode().value());
                IndexedWord depVertex = new IndexedWord(docID, sentIndex, dep.index(), depLabel);
                depVertex.setTag(dep.highestNodeWithSameHead().headTagNode().value());
                if (lemmatize) {
                    govVertex.setLemma(morphology.lemma(govVertex.value(), govVertex.tag(), true));
                    depVertex.setLemma(morphology.lemma(depVertex.value(), depVertex.tag(), true));
                }
                this.addVertex(govVertex);
                this.addVertex(depVertex);
                this.addEdge(govVertex, depVertex, reln, Double.NEGATIVE_INFINITY, d.extra());
                continue;
            }
            IndexedWord depVertex = new IndexedWord(docID, sentIndex, dep.index(), depLabel);
            depVertex.setTag(dep.highestNodeWithSameHead().headTagNode().value());
            if (lemmatize) {
                depVertex.setLemma(morphology.lemma(depVertex.value(), depVertex.tag(), true));
            }
            this.roots.add(depVertex);
        }
    }

    public List<IndexedWord> getShortestUndirectedPathNodes(IndexedWord source, IndexedWord target) {
        return this.graph.getShortestPath(source, target, false);
    }

    public List<SemanticGraphEdge> getShortestUndirectedPathEdges(IndexedWord source, IndexedWord target) {
        return this.graph.getShortestPathEdges(source, target, false);
    }

    public List<IndexedWord> getShortestDirectedPathNodes(IndexedWord source, IndexedWord target) {
        return this.graph.getShortestPath(source, target, true);
    }

    public List<SemanticGraphEdge> getShortestDirectedPathEdges(IndexedWord source, IndexedWord target) {
        return this.graph.getShortestPathEdges(source, target, true);
    }

    public boolean equals(Object o) {
        if (!(o instanceof SemanticGraph)) {
            return false;
        }
        SemanticGraph g = (SemanticGraph)o;
        return this.graph.equals(g.graph) && ((Object)this.roots).equals(g.roots);
    }

    public int hashCode() {
        return this.graph.hashCode();
    }

    public List<SemanticGraphEdge> findAllRelns(GrammaticalRelation tgtRelation) {
        ArrayList<SemanticGraphEdge> relns = new ArrayList<SemanticGraphEdge>();
        for (SemanticGraphEdge edge : this.edgeIterable()) {
            GrammaticalRelation edgeRelation = edge.getRelation();
            if (edgeRelation == null || !edgeRelation.equals(tgtRelation)) continue;
            relns.add(edge);
        }
        return relns;
    }

    public Collection<TypedDependency> typedDependencies() {
        ArrayList<TypedDependency> dependencies = new ArrayList<TypedDependency>();
        for (SemanticGraphEdge e : this.edgeIterable()) {
            TreeGraphNode gov = new TreeGraphNode(e.getGovernor());
            TreeGraphNode dep = new TreeGraphNode(e.getDependent());
            TypedDependency dependency = new TypedDependency(e.getRelation(), gov, dep);
            dependencies.add(dependency);
        }
        return dependencies;
    }

    private static class SemanticGraphParsingTask
    extends StringParsingTask<SemanticGraph> {
        private SemanticGraph sg;
        private Set<Integer> indexesUsed = Generics.newHashSet();

        public SemanticGraphParsingTask(String s) {
            super(s);
        }

        @Override
        public SemanticGraph parse() {
            this.sg = new SemanticGraph();
            try {
                this.readWhiteSpace();
                if (!SemanticGraphParsingTask.isLeftBracket(this.peek())) {
                    return null;
                }
                this.readDep(null, null);
                return this.sg;
            }
            catch (StringParsingTask.ParserException e) {
                System.err.println("SemanticGraphParser warning: " + e.getMessage());
                return null;
            }
        }

        private void readDep(IndexedWord gov, String reln) {
            this.readWhiteSpace();
            if (!SemanticGraphParsingTask.isLeftBracket(this.peek())) {
                String label = this.readName();
                IndexedWord dep = this.makeVertex(label);
                this.sg.addVertex(dep);
                if (gov == null) {
                    this.sg.roots.add(dep);
                }
                this.sg.addEdge(gov, dep, GrammaticalRelation.valueOf(reln), Double.NEGATIVE_INFINITY, false);
            } else {
                this.readLeftBracket();
                String label = this.readName();
                IndexedWord dep = this.makeVertex(label);
                this.sg.addVertex(dep);
                if (gov == null) {
                    this.sg.roots.add(dep);
                }
                if (gov != null && reln != null) {
                    this.sg.addEdge(gov, dep, GrammaticalRelation.valueOf(reln), Double.NEGATIVE_INFINITY, false);
                }
                this.readWhiteSpace();
                while (!SemanticGraphParsingTask.isRightBracket(this.peek()) && !this.isEOF) {
                    reln = this.readName();
                    this.readColon();
                    this.readDep(dep, reln);
                    this.readWhiteSpace();
                }
                this.readRightBracket();
            }
        }

        private IndexedWord makeVertex(String word) {
            Integer index;
            Pair<String, Integer> wordAndIndex = SemanticGraphParsingTask.readWordAndIndex(word);
            if (wordAndIndex != null) {
                word = wordAndIndex.first();
                index = wordAndIndex.second();
            } else {
                index = this.getNextFreeIndex();
            }
            this.indexesUsed.add(index);
            IndexedWord ifl = new IndexedWord(null, 0, index);
            String[] wordAndTag = word.split("/");
            ifl.set(CoreAnnotations.TextAnnotation.class, wordAndTag[0]);
            if (wordAndTag.length > 1) {
                ifl.set(CoreAnnotations.PartOfSpeechAnnotation.class, wordAndTag[1]);
            }
            return ifl;
        }

        private static Pair<String, Integer> readWordAndIndex(String word) {
            Matcher matcher = WORD_AND_INDEX_PATTERN.matcher(word);
            if (!matcher.matches()) {
                return null;
            }
            word = matcher.group(1);
            Integer index = Integer.valueOf(matcher.group(2));
            return new Pair<String, Integer>(word, index);
        }

        private Integer getNextFreeIndex() {
            int i = 0;
            while (this.indexesUsed.contains(i)) {
                ++i;
            }
            return i;
        }

        private void readLeftBracket() {
            this.readWhiteSpace();
            char ch = this.read();
            if (!SemanticGraphParsingTask.isLeftBracket(ch)) {
                throw new StringParsingTask.ParserException("Expected left paren!");
            }
        }

        private void readRightBracket() {
            this.readWhiteSpace();
            char ch = this.read();
            if (!SemanticGraphParsingTask.isRightBracket(ch)) {
                throw new StringParsingTask.ParserException("Expected right paren!");
            }
        }

        private void readColon() {
            this.readWhiteSpace();
            if (SemanticGraphParsingTask.isColon(this.peek())) {
                this.read();
            }
        }

        private static boolean isLeftBracket(char ch) {
            return ch == '[';
        }

        private static boolean isRightBracket(char ch) {
            return ch == ']';
        }

        private static boolean isColon(char ch) {
            return ch == ':';
        }

        @Override
        protected boolean isPunct(char ch) {
            return SemanticGraphParsingTask.isLeftBracket(ch) || SemanticGraphParsingTask.isRightBracket(ch) || SemanticGraphParsingTask.isColon(ch);
        }
    }
}

