#ifndef BASIC_H
#define BASIC_H

#include <cassert>
#include <libgen.h>

#define _STR(x) #x
#define STR(x) _STR(x)

#define BASENAME(file) basename(( char* )(file))
#define MESSAGE(tag, s, msg) \
    (s) << tag << BASENAME(__FILE__) << ':' << __LINE__ << ": " msg

#ifndef NDEBUG

#include <typeinfo>
#include <iostream>

#define TYPENAME(T) typeid(T).name()
#define LOG_DEBUG(msg) MESSAGE("[Debug] ", std::cerr, msg << std::endl)

#else

#define TYPENAME(T) "*"
#define LOG_DEBUG(msg)

#endif // DEBUG

#define LOG_WARNING(msg) MESSAGE("[Warning] ", std::cerr, msg << std::endl)
#define LOG_INFO(msg) MESSAGE("[Info] ", std::cout, msg << std::endl)
#define LOG_ERROR(msg) MESSAGE("[Error] ", std::cerr, msg << std::endl)

#endif /* BASIC_H */

// Local Variables:
// mode: c++
// End:
