/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;

public class FileKeyMap {
    private Map<String, String> map;
    private String basePath;

    public FileKeyMap(String basePath) {
        this.basePath = basePath;
        this.map = new LinkedHashMap<String, String>();
    }

    public void clear() {
        this.map.clear();
    }

    public String get(String fileKey) {
        String[] tokens = fileKey.split(":", 2);
        if (tokens.length != 2) {
            return null;
        }
        return this.get(tokens[0], tokens[1]);
    }

    public String get(String file, String key) {
        String fileKey = String.valueOf(file) + ":" + key;
        String value = this.map.get(fileKey);
        if (value == null) {
            try {
                for (String line : IOUtils.readLines(new File(this.basePath, file).toString())) {
                    String[] tokens = line.split("\t", 2);
                    if (tokens.length == 0) continue;
                    this.map.put(String.valueOf(file) + ":" + tokens[0], tokens.length == 1 ? "" : tokens[1]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            value = this.map.get(fileKey);
        }
        return value;
    }

    public boolean put(String fileKey, String value) {
        String[] tokens = fileKey.split(":", 2);
        if (tokens.length != 2) {
            return false;
        }
        return this.put(tokens[0], tokens[1], value);
    }

    public boolean put(String file, String key, String value) {
        this.get(file, key);
        this.map.put(String.valueOf(file) + ":" + key, value);
        PrintWriter out = IOUtils.openOutEasy(new File(this.basePath, file));
        if (out == null) {
            return false;
        }
        for (Map.Entry<String, String> e : this.map.entrySet()) {
            String[] tokens = e.getKey().split(":", 2);
            if (tokens.length != 2 || !tokens[0].equals(file)) continue;
            out.println(String.valueOf(tokens[1]) + "\t" + e.getValue());
        }
        out.close();
        return true;
    }
}

