###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

#!/usr/bin/ruby

require "scripts/umnlp.rb"

dist_hash = Hash.new

while(line = gets)
  if line =~ /^(.*) : (.*) = (.*)/
    if not dist_hash.has_key?($1)
      dist_hash[$1] = Array.new
    end
    dist_hash[$1] << ValueProb.new($2, $3.to_f)
  end
end

dist_size = 5

dist_hash.each_key{ |key|
  outcomes = dist_hash[key]
  outcomes.sort!{ |x,y| y.prob <=> x.prob }
  sum = 1.0
  if outcomes.size > dist_size
    outcomes.slice!(dist_size..-1)
    sum = 0.0
    outcomes.each{ |outcome|
      sum += outcome.prob
    }
  end
  
  outcomes.each{ |outcome|
    puts "#{key} : #{outcome.value} = #{outcome.prob / sum}"
  }
}
