import tensorflow as tf
beam_size=4
beam_parent=[0,0,1,1]
beam_probs=[0.1,0.2,0.15,0.124]

def step(previous_hidden_memory_tuple, x):
    h_prev, prev_output = tf.unpack(previous_hidden_memory_tuple)
    cur_index = tf.one_hot(x, depth=beam_size, on_value=1, off_value=0, dtype=tf.int32)
    cur_output = tf.gather(h_prev, x)
    return tf.pack([h_prev + cur_index, prev_output+cur_output])


init_state = tf.pack([tf.ones(beam_size, dtype=tf.int32, name='incremental_index'),
                              tf.zeros(beam_size, dtype=tf.int32, name='output')])
diverse_part = tf.scan(step, beam_parent, initializer=init_state)

with tf.Session() as sess:
    # sess.run(tf.global_variables_initializer())
    print(sess.run(diverse_part))
