
for model in 't5_small'; do
    for method in 'lora'; do
        for data in 'scifact_oracle' 'cfever' 'fever' 'scifact'; do
            echo $method; echo $model; echo $data
            #seq2seq c2e
            time python maple/seq2seq.py \
            --model ${model} \
            --dataset ${data} \
            --dataset_dir data \
            --direction ce \
            --output_dir maple \
            --num_epochs 21

            #semsim c2e
            time python maple/aggregate_semsim.py \
            --dataset_train $data \
            --dataset_test $data \
            --seq2seq_model_path maple/ce/${method}_${model}_${data} \
            --output_dir maple/ce/${method}_${model}_${data}/aggregate \
            --num_epochs 21

            #seq2seq e2c
            time python maple_lora/seq2seq.py \
            --model ${model} \
            --dataset ${data} \
            --dataset_dir data \
            --direction ec \
            --output_dir maple \
            --num_epochs 21

            #semsim e2c
            time python maple/aggregate_semsim.py \
            --dataset_train $data \
            --dataset_test $data \
            --seq2seq_model_path maple/ec/${method}_${model}_${data} \
            --output_dir maple/ec/${method}_${model}_${data}/aggregate \
            --num_epochs 21

            time python maple/LR_train.py \
            --datasets ${data} \
            --d maple \
            --output_dir maple_lora_results \
            --num_epochs 21
        done
    done
done


