/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.trees.BobChrisTreeNormalizer;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.international.pennchinese.CHTBTokenizer;
import edu.stanford.nlp.trees.international.pennchinese.FragDiscardingPennTreeReader;
import java.io.Reader;

public class CTBTreeReaderFactory
implements TreeReaderFactory {
    private final TreeNormalizer tn;
    private final boolean discardFrags;

    public CTBTreeReaderFactory() {
        this(new TreeNormalizer());
    }

    public CTBTreeReaderFactory(TreeNormalizer tn) {
        this(tn, false);
    }

    public CTBTreeReaderFactory(TreeNormalizer tn, boolean discardFrags) {
        this.tn = tn;
        this.discardFrags = discardFrags;
    }

    @Override
    public TreeReader newTreeReader(Reader in) {
        if (this.discardFrags) {
            return new FragDiscardingPennTreeReader(in, new LabeledScoredTreeFactory(), this.tn, new CHTBTokenizer(in));
        }
        return new PennTreeReader(in, new LabeledScoredTreeFactory(), this.tn, new CHTBTokenizer(in));
    }

    public static class NoEmptiesCTBTreeReaderFactory
    extends CTBTreeReaderFactory {
        public NoEmptiesCTBTreeReaderFactory() {
            super(new BobChrisTreeNormalizer());
        }
    }
}

