/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.patterns.surface.ConstantsAndVariables;
import edu.stanford.nlp.patterns.surface.GetPatternsFromDataMultiClass;
import edu.stanford.nlp.patterns.surface.ScorePatterns;
import edu.stanford.nlp.patterns.surface.SurfacePattern;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.util.CollectionUtils;
import java.util.Map;
import java.util.Properties;

public class ScorePatternsF1
extends ScorePatterns {
    Counter<String> p0Set = null;
    SurfacePattern p0;

    public ScorePatternsF1(ConstantsAndVariables constVars, GetPatternsFromDataMultiClass.PatternScoring patternScoring, String label, TwoDimensionalCounter<SurfacePattern, String> patternsandWords4Label, TwoDimensionalCounter<SurfacePattern, String> negPatternsandWords4Label, TwoDimensionalCounter<SurfacePattern, String> unLabeledPatternsandWords4Label, TwoDimensionalCounter<SurfacePattern, String> negandUnLabeledPatternsandWords4Label, TwoDimensionalCounter<SurfacePattern, String> allPatternsandWords4Label, Properties props, Counter<String> p0Set, SurfacePattern p0) {
        super(constVars, patternScoring, label, patternsandWords4Label, negPatternsandWords4Label, unLabeledPatternsandWords4Label, negandUnLabeledPatternsandWords4Label, allPatternsandWords4Label, props);
        this.p0 = p0;
        this.p0Set = p0Set;
    }

    @Override
    public void setUp(Properties props) {
    }

    @Override
    Counter<SurfacePattern> score() {
        ClassicCounter specificity = new ClassicCounter();
        ClassicCounter sensitivity = new ClassicCounter();
        if (this.p0Set.keySet().size() == 0) {
            throw new RuntimeException("how come p0set size is empty for " + this.p0 + "?");
        }
        for (Map.Entry en : this.patternsandWords4Label.entrySet()) {
            int common = CollectionUtils.intersection(en.getValue().keySet(), this.p0Set.keySet()).size();
            if (common == 0) continue;
            if (en.getValue().keySet().size() == 0) {
                throw new RuntimeException("how come counter for " + en.getKey() + " is empty?");
            }
            specificity.setCount(en.getKey(), (double)common / (double)en.getValue().keySet().size());
            sensitivity.setCount(en.getKey(), (double)common / (double)this.p0Set.size());
        }
        Counters.retainNonZeros(specificity);
        Counters.retainNonZeros(sensitivity);
        Counter add = Counters.add(sensitivity, specificity);
        Counter product = Counters.product(sensitivity, specificity);
        Counters.retainNonZeros(product);
        Counters.retainKeys(product, add.keySet());
        Counter<SurfacePattern> finalPat = Counters.scale(Counters.division(product, add), 2.0);
        return finalPat;
    }
}

