/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex.matcher;

import edu.stanford.nlp.ling.tokensregex.matcher.Match;
import edu.stanford.nlp.util.HasInterval;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class MultiMatch<K, V>
extends Match<K, V> {
    List<Match<K, V>> multimatches;

    public MultiMatch() {
    }

    public MultiMatch(List<K> matched, V value, int begin, int end, List<Match<K, V>> multimatches) {
        this.matched = matched;
        this.value = value;
        this.begin = begin;
        this.end = end;
        this.multimatches = multimatches;
    }

    public List<Match<K, V>> getMultimatches() {
        return this.multimatches;
    }

    public List<List<K>> getMultimatched() {
        if (this.multimatches == null) {
            return null;
        }
        ArrayList<List<K>> multimatched = new ArrayList<List<K>>(this.multimatches.size());
        for (Match<K, V> m : this.multimatches) {
            multimatched.add(m.getMatched());
        }
        return multimatched;
    }

    public List<V> getMultivalues() {
        if (this.multimatches == null) {
            return null;
        }
        ArrayList<V> multivalues = new ArrayList<V>(this.multimatches.size());
        for (Match<K, V> m : this.multimatches) {
            multivalues.add(m.getValue());
        }
        return multivalues;
    }

    public List<HasInterval<Integer>> getMultioffsets() {
        if (this.multimatches == null) {
            return null;
        }
        ArrayList<HasInterval<Integer>> multioffsets = new ArrayList<HasInterval<Integer>>(this.multimatches.size());
        for (Match<K, V> m : this.multimatches) {
            multioffsets.add(m.getInterval());
        }
        return multioffsets;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultiMatch that = (MultiMatch)o;
        return !(this.multimatches != null ? !((Object)this.multimatches).equals(that.multimatches) : that.multimatches != null);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.multimatches != null) {
            sb.append("[" + StringUtils.join(this.getMultimatches(), ", ") + "]");
        } else {
            sb.append(super.toString());
        }
        return sb.toString();
    }
}

