/*
 * Decompiled with CFR 0.152.
 */
import edu.cmu.meteor.scorer.MeteorConfiguration;
import edu.cmu.meteor.scorer.MeteorScorer;
import edu.cmu.meteor.scorer.MeteorStats;
import edu.cmu.meteor.util.Constants;
import edu.cmu.meteor.util.SGMData;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class Meteor {
    public static void main(String[] stringArray) {
        String string;
        if (stringArray.length < 2) {
            Meteor.printUsage();
            System.exit(2);
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Properties properties = Meteor.createPropertiesFromArgs(stringArray, 2);
        MeteorConfiguration meteorConfiguration = new MeteorConfiguration(properties);
        Boolean bl = Boolean.parseBoolean(properties.getProperty("ssOut"));
        Boolean bl2 = Boolean.parseBoolean(properties.getProperty("sgml"));
        Boolean bl3 = Boolean.parseBoolean(properties.getProperty("stdio"));
        Boolean bl4 = Boolean.parseBoolean(properties.getProperty("quiet"));
        String string4 = string = bl2 != false ? "SGML" : "plaintext";
        if (!(bl.booleanValue() || bl3.booleanValue() || bl4.booleanValue())) {
            System.out.println("Meteor version: 1.5");
            System.out.println();
            System.out.println("Eval ID:        " + meteorConfiguration.getConfigID());
            System.out.println();
            System.out.println("Language:       " + meteorConfiguration.getLanguage().substring(0, 1).toUpperCase() + meteorConfiguration.getLanguage().substring(1));
            System.out.println("Format:         " + string);
            System.out.println("Task:           " + meteorConfiguration.getTaskDesc());
            System.out.println("Modules:        " + meteorConfiguration.getModulesString());
            System.out.println("Weights:        " + meteorConfiguration.getModuleWeightsString());
            System.out.println("Parameters:     " + meteorConfiguration.getParametersString());
            System.out.println();
        }
        if (meteorConfiguration.getModuleWeights().size() < meteorConfiguration.getModules().size()) {
            System.err.println("Warning: More modules than weights specified - modules with no weights will not be counted.");
        }
        if (bl3.booleanValue() && bl2.booleanValue()) {
            System.err.println("Warning: Stdio incompatible with other modes - using Stdio only");
        }
        MeteorScorer meteorScorer = new MeteorScorer(meteorConfiguration);
        if (bl3.booleanValue()) {
            try {
                Meteor.scoreStdio(meteorScorer);
            }
            catch (IOException iOException) {
                System.err.println("Error: Could not score Stdio inputs");
                iOException.printStackTrace();
                System.exit(1);
            }
        } else if (bl2.booleanValue()) {
            try {
                Meteor.scoreSGML(meteorScorer, properties, meteorConfiguration, string2, string3);
            }
            catch (IOException iOException) {
                System.err.println("Error: Could not score SGML files:");
                iOException.printStackTrace();
                System.exit(1);
            }
        } else {
            try {
                Meteor.scorePlaintext(meteorScorer, properties, meteorConfiguration, string2, string3);
            }
            catch (IOException iOException) {
                System.err.println("Error: Could not score text files:");
                iOException.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static int getRefCount(Properties properties) {
        String string = properties.getProperty("refCount");
        if (string == null) {
            return 1;
        }
        return Integer.parseInt(string);
    }

    private static void scorePlaintext(MeteorScorer meteorScorer, Properties properties, MeteorConfiguration meteorConfiguration, String string, String string2) throws IOException {
        Object object;
        Object object2;
        String string3;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
        while ((string3 = bufferedReader.readLine()) != null) {
            arrayList.add(string3);
        }
        bufferedReader.close();
        int n = Meteor.getRefCount(properties);
        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string2), "UTF-8"));
        if (n == 1) {
            while ((string3 = bufferedReader.readLine()) != null) {
                arrayList2.add(string3);
            }
        } else {
            while ((string3 = bufferedReader.readLine()) != null) {
                object2 = new ArrayList<String>();
                ((ArrayList)object2).add(string3);
                for (int i = 1; i < n; ++i) {
                    ((ArrayList)object2).add(bufferedReader.readLine());
                }
                arrayList3.add(object2);
            }
        }
        bufferedReader.close();
        if (n == 1 && arrayList.size() != arrayList2.size() || n > 1 && arrayList.size() != arrayList3.size()) {
            System.err.println("Error: test and reference not same length");
            return;
        }
        object2 = new MeteorStats();
        Boolean bl = Boolean.parseBoolean(properties.getProperty("writeAlignments"));
        PrintWriter printWriter = null;
        if (bl.booleanValue()) {
            object = properties.getProperty("filePrefix");
            if (object == null) {
                object = "meteor";
            }
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((String)object + "-align.out"), "UTF-8"));
        }
        object = Boolean.parseBoolean(properties.getProperty("ssOut"));
        Boolean bl2 = Boolean.parseBoolean(properties.getProperty("vOut"));
        Boolean bl3 = Boolean.parseBoolean(properties.getProperty("quiet"));
        for (int i = 0; i < arrayList.size(); ++i) {
            MeteorStats meteorStats = n == 1 ? meteorScorer.getMeteorStats((String)arrayList.get(i), (String)arrayList2.get(i)) : meteorScorer.getMeteorStats((String)arrayList.get(i), (ArrayList<String>)((ArrayList)arrayList3.get(i)));
            if (((Boolean)object).booleanValue()) {
                System.out.println(meteorStats.toString());
            } else if (bl2.booleanValue()) {
                System.out.println("Segment " + (i + 1) + " score:\t" + meteorStats.precision + "\t" + meteorStats.recall + "\t" + meteorStats.fragPenalty + "\t" + meteorStats.score);
            } else if (bl3.booleanValue()) {
                System.err.println(meteorStats.score);
            } else {
                System.out.println("Segment " + (i + 1) + " score:\t" + meteorStats.score);
            }
            if (bl.booleanValue()) {
                printWriter.println(meteorStats.alignment.toString("Alignment\t" + (i + 1) + "\t" + meteorStats.precision + "\t" + meteorStats.recall + "\t" + meteorStats.fragPenalty + "\t" + meteorStats.score));
            }
            ((MeteorStats)object2).addStats(meteorStats);
        }
        if (bl.booleanValue()) {
            printWriter.close();
        }
        if (!((Boolean)object).booleanValue()) {
            meteorScorer.computeMetrics((MeteorStats)object2);
            if (bl3.booleanValue()) {
                System.out.println(((MeteorStats)object2).score);
            } else {
                Meteor.printVerboseStats((MeteorStats)object2, meteorConfiguration);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void scoreSGML(MeteorScorer meteorScorer, Properties properties, MeteorConfiguration meteorConfiguration, String string, String string2) throws IOException {
        Object object;
        Object object2;
        SGMData sGMData = new SGMData();
        SGMData.populate(sGMData, string, false);
        SGMData.populate(sGMData, string2, true);
        Boolean bl = Boolean.parseBoolean(properties.getProperty("ssOut"));
        Boolean bl2 = Boolean.parseBoolean(properties.getProperty("vOut"));
        String string3 = properties.getProperty("filePrefix");
        if (string3 == null) {
            string3 = "meteor";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        Hashtable<String, MeteorStats> hashtable = new Hashtable<String, MeteorStats>();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(sGMData.testData.keySet());
        hashSet.addAll(sGMData.refData.keySet());
        for (String object32 : hashSet) {
            object2 = sGMData.refData.get(object32);
            Hashtable<String, Hashtable<String, Hashtable<String, String>>> hashtable2 = sGMData.testData.get(object32);
            for (String string4 : hashtable2.keySet()) {
                Object object3;
                Object object42;
                Object object52;
                MeteorStats meteorStats = new MeteorStats();
                object = hashtable2.get(string4);
                ArrayList arrayList4 = new ArrayList();
                ArrayList<Object> arrayList5 = new ArrayList<Object>();
                for (Object object52 : ((Hashtable)object2).keySet()) {
                    arrayList4.add(((Hashtable)object2).get(object52));
                    arrayList5.add(object52);
                }
                object52 = new HashSet();
                ((AbstractCollection)object52).addAll(((Hashtable)object).keySet());
                for (Object object42 : arrayList4) {
                    ((AbstractCollection)object52).addAll(((Hashtable)object42).keySet());
                }
                Iterator iterator = ((HashSet)object52).iterator();
                while (iterator.hasNext()) {
                    String string5;
                    object42 = (String)iterator.next();
                    object3 = new MeteorStats();
                    Hashtable<String, String> hashtable3 = ((Hashtable)object).get(object42);
                    if (hashtable3 == null) {
                        System.err.println("Warning: no data for system [" + string4 + "] on document [" + object32 + "][" + (String)object42 + "] - skipping this document");
                        continue;
                    }
                    ArrayList<Hashtable> arrayList6 = new ArrayList<Hashtable>();
                    ArrayList arrayList7 = new ArrayList();
                    for (int i = 0; i < arrayList4.size(); ++i) {
                        Iterator iterator2 = (String)arrayList5.get(i);
                        Hashtable hashtable4 = (Hashtable)((Hashtable)arrayList4.get(i)).get(object42);
                        if (hashtable4 == null) {
                            System.err.println("Warning: no data for reference [" + iterator2 + "] on document [" + object32 + "][" + (String)object42 + "]");
                            continue;
                        }
                        arrayList7.add(iterator2);
                        arrayList6.add(hashtable4);
                    }
                    if (arrayList6.size() == 0) {
                        System.err.println("Warning: no usable references for document [" + object32 + "][" + (String)object42 + "] - skipping this document");
                        continue;
                    }
                    HashSet<String> hashSet2 = new HashSet<String>();
                    hashSet2.addAll(hashtable3.keySet());
                    for (Hashtable hashtable5 : arrayList6) {
                        hashSet2.addAll(hashtable5.keySet());
                    }
                    for (String string6 : hashSet2) {
                        String string7;
                        String string8;
                        string5 = hashtable3.get(string6);
                        if (string5 == null) {
                            System.err.println("Warning: no data for system [" + string4 + "] on segment [" + object32 + "][" + (String)object42 + "][" + string6 + "] - scoring empty segment");
                            string5 = "";
                        }
                        ArrayList<String> arrayList8 = new ArrayList<String>();
                        for (int i = 0; i < arrayList6.size(); ++i) {
                            string8 = (String)arrayList7.get(i);
                            string7 = (String)((Hashtable)arrayList6.get(i)).get(string6);
                            if (string7 == null) {
                                System.err.println("Warning: no data for reference [" + string8 + "] on segment [" + object32 + "][" + (String)object42 + "][" + string6 + "]");
                                continue;
                            }
                            arrayList8.add(string7);
                        }
                        if (arrayList8.size() == 0) {
                            System.err.println("Warning: no usable references for segment [" + object32 + "][" + (String)object42 + "][" + string6 + "] - skipping this segment");
                            continue;
                        }
                        MeteorStats meteorStats2 = meteorScorer.getMeteorStats(string5, arrayList8);
                        ((MeteorStats)object3).addStats(meteorStats2);
                        meteorStats.addStats(meteorStats2);
                        string8 = object32 + "\t" + string4 + "\t" + (String)object42 + "\t" + string6 + "\t";
                        string7 = bl != false ? meteorStats2.toString() : (bl2 != false ? String.valueOf(meteorStats2.precision + "\t" + meteorStats2.recall + "\t" + meteorStats2.fragPenalty + "\t" + meteorStats2.score) : String.valueOf(meteorStats2.score));
                        String string9 = string8 + string7;
                        arrayList3.add(string9);
                        hashtable.put(string9, meteorStats2);
                    }
                    meteorScorer.computeMetrics((MeteorStats)object3);
                    String string10 = object32 + "\t" + string4 + "\t" + (String)object42 + "\t";
                    string5 = bl != false ? ((MeteorStats)object3).toString() : (bl2 != false ? String.valueOf(((MeteorStats)object3).precision + "\t" + ((MeteorStats)object3).recall + "\t" + ((MeteorStats)object3).fragPenalty + "\t" + ((MeteorStats)object3).score) : String.valueOf(((MeteorStats)object3).score));
                    arrayList2.add(string10 + string5);
                }
                meteorScorer.computeMetrics(meteorStats);
                object42 = object32 + "\t" + string4 + "\t";
                object3 = bl != false ? meteorStats.toString() : (bl2 != false ? String.valueOf(meteorStats.precision + "\t" + meteorStats.recall + "\t" + meteorStats.fragPenalty + "\t" + meteorStats.score) : String.valueOf(meteorStats.score));
                arrayList.add((String)object42 + (String)object3);
                if (bl.booleanValue()) continue;
                Meteor.printVerboseStats(meteorStats, meteorConfiguration, "[" + object32 + "][" + string4 + "] ");
                System.out.println();
            }
        }
        Collections.sort(arrayList, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                int n = string.lastIndexOf("\t");
                String string3 = string.substring(0, n);
                int n2 = string2.lastIndexOf("\t");
                String string4 = string2.substring(0, n2);
                return string3.compareTo(string4);
            }
        });
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string3 + "-sys.scr"), "UTF-8"));
        for (String string11 : arrayList) {
            printWriter.println(string11);
        }
        printWriter.close();
        Collections.sort(arrayList2, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                int n = string.lastIndexOf("\t");
                String string3 = string.substring(0, n);
                int n2 = string2.lastIndexOf("\t");
                String string4 = string2.substring(0, n2);
                return string3.compareTo(string4);
            }
        });
        PrintWriter printWriter2 = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string3 + "-doc.scr"), "UTF-8"));
        for (String string12 : arrayList2) {
            printWriter2.println(string12);
        }
        printWriter2.close();
        Collections.sort(arrayList3, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                int n;
                int n2;
                String string3;
                int n3 = string.lastIndexOf("\t");
                int n4 = string.lastIndexOf("\t", n3 - 1);
                String string4 = string.substring(0, n4);
                int n5 = string4.compareTo(string3 = string2.substring(0, n2 = string2.lastIndexOf("\t", (n = string2.lastIndexOf("\t")) - 1)));
                if (n5 != 0) {
                    return n5;
                }
                String string5 = string.substring(n4 + 1, n3);
                String string6 = string2.substring(n2 + 1, n);
                try {
                    int n6 = Integer.parseInt(string5);
                    int n7 = Integer.parseInt(string6);
                    return n6 - n7;
                }
                catch (Exception exception) {
                    return string5.compareTo(string6);
                }
            }
        });
        PrintWriter printWriter3 = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string3 + "-seg.scr"), "UTF-8"));
        for (String string13 : arrayList3) {
            printWriter3.println(string13);
        }
        printWriter3.close();
        object2 = Boolean.parseBoolean(properties.getProperty("writeAlignments"));
        if (((Boolean)object2).booleanValue()) {
            void var17_29;
            PrintWriter printWriter4 = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string3 + "-align.out"), "UTF-8"));
            boolean bl3 = false;
            while (var17_29 < arrayList3.size()) {
                String string14 = (String)arrayList3.get((int)var17_29);
                MeteorStats meteorStats = (MeteorStats)hashtable.get(string14);
                int n = -1;
                for (int i = 0; i < 4; ++i) {
                    n = string14.indexOf(9, n + 1);
                }
                object = string14.substring(0, n);
                printWriter4.println(meteorStats.alignment.toString("Alignment\t" + (String)object + '\t' + meteorStats.precision + "\t" + meteorStats.recall + "\t" + meteorStats.fragPenalty + "\t" + meteorStats.score));
                ++var17_29;
            }
            printWriter4.close();
        }
    }

    private static void scoreStdio(MeteorScorer meteorScorer) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        while ((string = bufferedReader.readLine()) != null) {
            Object object;
            String[] stringArray;
            if (string.startsWith("SCORE") || string.startsWith("score")) {
                stringArray = string.split("\\|\\|\\|");
                if (stringArray.length < 3) {
                    System.out.println("Error: specify hypothesis and at least one reference");
                    continue;
                }
                object = new ArrayList<String>();
                for (int i = 1; i < stringArray.length - 1; ++i) {
                    ((ArrayList)object).add(stringArray[i].trim());
                }
                String string2 = stringArray[stringArray.length - 1].trim();
                MeteorStats meteorStats = meteorScorer.getMeteorStats(string2, (ArrayList<String>)object);
                System.out.println(meteorStats.toString());
                continue;
            }
            if (string.startsWith("EVAL") || string.startsWith("eval")) {
                stringArray = string.split("\\|\\|\\|");
                if (stringArray.length < 2) {
                    System.out.println("Error: specify Meteor stats");
                    continue;
                }
                object = new MeteorStats(stringArray[1].trim());
                meteorScorer.computeMetrics((MeteorStats)object);
                System.out.println(((MeteorStats)object).score);
                continue;
            }
            System.out.println("Error: specify SCORE or EVAL");
        }
    }

    private static void printVerboseStats(MeteorStats meteorStats, MeteorConfiguration meteorConfiguration) {
        Meteor.printVerboseStats(meteorStats, meteorConfiguration, "\nSystem level statistics:\n");
    }

    private static void printVerboseStats(MeteorStats meteorStats, MeteorConfiguration meteorConfiguration, String string) {
        System.out.println(string);
        System.out.println();
        System.out.println("           Test Matches                  Reference Matches");
        System.out.println("Stage      Content  Function    Total    Content  Function    Total");
        ArrayList<Double> arrayList = meteorConfiguration.getModuleWeights();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < arrayList.size(); ++i) {
            System.out.println(String.format("%1d          %7s   %7s  %7s    %7s   %7s  %7s", i + 1, Constants.minFormat.format(meteorStats.testStageMatchesContent.get(i)), Constants.minFormat.format(meteorStats.testStageMatchesFunction.get(i)), Constants.minFormat.format(meteorStats.testStageMatchesContent.get(i) + meteorStats.testStageMatchesFunction.get(i)), Constants.minFormat.format(meteorStats.referenceStageMatchesContent.get(i)), Constants.minFormat.format(meteorStats.referenceStageMatchesFunction.get(i)), Constants.minFormat.format(meteorStats.referenceStageMatchesContent.get(i) + meteorStats.referenceStageMatchesFunction.get(i))));
            d += meteorStats.testStageMatchesContent.get(i).doubleValue();
            d2 += meteorStats.testStageMatchesFunction.get(i).doubleValue();
            d3 += meteorStats.referenceStageMatchesContent.get(i).doubleValue();
            d4 += meteorStats.referenceStageMatchesFunction.get(i).doubleValue();
        }
        System.out.println(String.format("Total      %7s   %7s  %7s    %7s   %7s  %7s", Constants.minFormat.format(d), Constants.minFormat.format(d2), Constants.minFormat.format(d + d2), Constants.minFormat.format(d3), Constants.minFormat.format(d4), Constants.minFormat.format(d3 + d4)));
        System.out.println();
        System.out.println("Test " + (meteorConfiguration.getCharBased() ? "char" : "word") + "s:             " + Constants.minFormat.format(meteorStats.testLength));
        System.out.println("Reference " + (meteorConfiguration.getCharBased() ? "char" : "word") + "s:        " + Constants.minFormat.format(meteorStats.referenceLength));
        System.out.println("Chunks:                 " + Constants.minFormat.format(meteorStats.chunks));
        System.out.println("Precision:              " + meteorStats.precision);
        System.out.println("Recall:                 " + meteorStats.recall);
        System.out.println("f1:                     " + meteorStats.f1);
        System.out.println("fMean:                  " + meteorStats.fMean);
        System.out.println("Fragmentation penalty:  " + meteorStats.fragPenalty);
        System.out.println();
        System.out.println("Final score:            " + meteorStats.score);
    }

    public static Properties createPropertiesFromArgs(String[] stringArray, int n) {
        Properties properties = new Properties();
        int n2 = n;
        while (n2 < stringArray.length) {
            String string;
            if (stringArray[n2].equals("-l")) {
                properties.setProperty("language", stringArray[n2 + 1]);
                n2 += 2;
            } else if (stringArray[n2].equals("-t")) {
                properties.setProperty("task", stringArray[n2 + 1]);
                n2 += 2;
            } else if (stringArray[n2].equals("-p")) {
                properties.setProperty("parameters", stringArray[n2 + 1]);
                n2 += 2;
            } else if (stringArray[n2].equals("-m")) {
                properties.setProperty("modules", stringArray[n2 + 1]);
                n2 += 2;
            } else if (stringArray[n2].equals("-w")) {
                properties.setProperty("moduleWeights", stringArray[n2 + 1]);
                n2 += 2;
            } else if (stringArray[n2].equals("-r")) {
                properties.setProperty("refCount", stringArray[n2 + 1]);
                n2 += 2;
            } else if (stringArray[n2].equals("-x")) {
                properties.setProperty("beamSize", stringArray[n2 + 1]);
                n2 += 2;
            } else if (stringArray[n2].equals("-s")) {
                properties.setProperty("wordFile", stringArray[n2 + 1]);
                n2 += 2;
            } else if (stringArray[n2].equals("-d")) {
                properties.setProperty("synDir", stringArray[n2 + 1]);
                n2 += 2;
            } else if (stringArray[n2].equals("-a")) {
                properties.setProperty("paraFile", stringArray[n2 + 1]);
                n2 += 2;
            } else if (stringArray[n2].equals("-f")) {
                properties.setProperty("filePrefix", stringArray[n2 + 1]);
                n2 += 2;
            } else if (stringArray[n2].equals("-new")) {
                properties.setProperty("newLang", "true");
                properties.setProperty("filesDir", stringArray[n2 + 1]);
                n2 += 2;
            } else if (stringArray[n2].equals("-ch")) {
                properties.setProperty("charBased", "true");
                ++n2;
            } else if (stringArray[n2].equals("-q")) {
                properties.setProperty("quiet", "true");
                ++n2;
            } else if (stringArray[n2].equals("-writeAlignments")) {
                properties.setProperty("writeAlignments", "true");
                ++n2;
            } else if (stringArray[n2].equals("-norm")) {
                properties.setProperty("norm", "true");
                ++n2;
            } else if (stringArray[n2].equals("-lower")) {
                properties.setProperty("lower", "true");
                ++n2;
            } else if (stringArray[n2].equals("-sgml")) {
                properties.setProperty("sgml", "true");
                ++n2;
            } else if (stringArray[n2].equals("-stdio") || stringArray[n2].equals("-mira")) {
                properties.setProperty("stdio", "true");
                ++n2;
            } else if (stringArray[n2].equals("-noPunct")) {
                properties.setProperty("noPunct", "true");
                ++n2;
            } else if (stringArray[n2].equals("-ssOut")) {
                properties.setProperty("ssOut", "true");
                ++n2;
            } else if (stringArray[n2].equals("-vOut")) {
                properties.setProperty("vOut", "true");
                ++n2;
            } else {
                System.err.println("Unknown option \"" + stringArray[n2] + "\"");
                System.exit(1);
            }
            if ((string = properties.getProperty("parameters")) == null) continue;
            properties.setProperty("task", "custom (" + string + ")");
        }
        return properties;
    }

    private static void printUsage() {
        System.err.println("Meteor version 1.5");
        System.err.println();
        System.err.println("Usage: java -Xmx2G -jar meteor-*.jar <test> <reference> [options]");
        System.err.println();
        System.err.println("Options:");
        System.err.println("-l language                     Fully supported: en cz de es fr");
        System.err.println("                                Supported with language-independent parameters:");
        System.err.println("                                  da fi hu it nl no pt ro ru se tr");
        System.err.println("                                Experimental:");
        System.err.println("                                  ar-bw-red");
        System.err.println("-t task                         One of: rank util adq hter li tune");
        System.err.println("                                  util implies -ch");
        System.err.println("-p 'alpha beta gamma delta'     Custom parameters (overrides default)");
        System.err.println("-m 'module1 module2 ...'        Specify modules (overrides default)");
        System.err.println("                                  Any of: exact stem synonym paraphrase");
        System.err.println("-w 'weight1 weight2 ...'        Specify module weights (overrides default)");
        System.err.println("-r refCount                     Number of references (plaintext only)");
        System.err.println("-x beamSize                     (default 40)");
        System.err.println("-s wordListFile                 (if not default for language)");
        System.err.println("-d synonymDirectory             (if not default for language)");
        System.err.println("-a paraphraseFile               (if not default for language)");
        System.err.println("-f filePrefix                   Prefix for output files (default 'meteor')");
        System.err.println("-q                              Quiet: Segment scores to stderr, final to stdout,");
        System.err.println("                                  no additional output (plaintext only)");
        System.err.println("-new files-dir                  New language! (files-dir contains function.words and paraphrase.gz)");
        System.err.println("                                  implies -lower");
        System.err.println("-ch                             Character-based precision and recall");
        System.err.println("-norm                           Tokenize / normalize punctuation and lowercase");
        System.err.println("                                  (Recommended unless scoring raw output with");
        System.err.println("                                   pretokenized references)");
        System.err.println("-lower                          Lowercase only (not required if -norm specified)");
        System.err.println("-noPunct                        Do not consider punctuation when scoring");
        System.err.println("                                  (Not recommended unless special case)");
        System.err.println("-sgml                           Input is in SGML format");
        System.err.println("-stdio                           Input is from stdin, see README for format");
        System.err.println("                                  (Use '-' for test and reference files)");
        System.err.println("-vOut                           Output verbose scores (P / R / frag / score)");
        System.err.println("-ssOut                          Output sufficient statistics instead of scores");
        System.err.println("-writeAlignments                Output alignments annotated with Meteor scores");
        System.err.println("                                  (written to <prefix>-align.out)");
        System.err.println();
        System.err.println("Sample options for plaintext: -l <lang> -norm");
        System.err.println("Sample options for SGML: -l <lang> -norm -sgml");
        System.err.println("Sample options for raw output / pretokenized references: -l <lang> -lower");
        System.err.println("Sample options for new language (plaintext): -new meteor-files");
        System.err.println();
        System.err.println("See README file for additional information");
    }
}

