#!/bin/bash
# This file will generate a CSV file containing the mean rank numbers from a selected log file

# Start by parsing arguments
TARGET_FILE=$1
declare -i LOGGING_INTERVAL=500

# Set a few configuration variables
TARGET_DIR="../output/logs/"

# Get the target file
target="$TARGET_DIR$TARGET_FILE"

# Grep it for MRR numbers & store it in a temporary file
grep MRR $target | awk -F ' ' '{print $11}' > ./temp

# For each line in the file, output it to CSV
echo "iteration,mean rank" > output.csv
declare -i iteration=0
while read p; do
    echo "$iteration,$p" >> output.csv
    iteration=$(($iteration + $LOGGING_INTERVAL))
done < ./temp

# Clean up the temporary file
rm ./temp