export CUDA_VISIBLE_DEVICES=4,5,6,7
model=eacl/123_1tag
python3 train.py data-bin/eacl/eacl.2 \
    --arch multilingual_transformer \
    --max-epoch 80 --fp16 \
    --encoder-langtok "tgt" \
    --task multilingual_translation --lang-pairs en-ta,en-te,en-ml \
    --share-encoders --share-decoders \
    --share-all-embeddings --share-decoder-input-output-embed \
    --optimizer adam --adam-betas '(0.9, 0.98)' \
    --lr-scheduler inverse_sqrt --warmup-init-lr 1e-07 --warmup-updates 4000 \
    --lr 0.0007 --ddp-backend=no_c10d \
    --dropout 0.3 \
    --weight-decay 0.0 --clip-norm 0.0 --criterion label_smoothed_cross_entropy --label-smoothing 0.1 \
    --max-tokens 2000 --update-freq 8 \
    --no-progress-bar --log-format json --log-interval 20 \
    --save-dir checkpoints/$model |tee -a  logs/$model.log
