from nltk.corpus import wordnet as wn

import pandas as pd

mammal = wn.synset('mammal.n.01')

def get_edges(root):
    edges = set()
    hypos = root.hyponyms() + root.instance_hyponyms()
    if len(hypos) == 0:
        return []
    else:
        for h in hypos:
            if h.name() in ['female_mammal.n.01', 'tusker.n.01']:
                continue
            edges.add((root.name(), h.name(), 1))
            sub_edges = get_edges(h)
            edges.update(sub_edges)
            for e in sub_edges:
                edges.add((root.name(), e[0], 1))
                edges.add((root.name(), e[1], 1))
    return edges

edges = get_edges(mammal)

pd.DataFrame(edges, columns=['id1', 'id2', 'weights']).to_csv('mammal_closure.csv')
