# -*- coding: utf-8 -*-

from abc import ABCMeta
from collections import UserList, namedtuple


def maybe_to_span(misc):
    prefix = 'TokenRange='
    if misc.startswith(prefix):
        misc = tuple(map(int, misc[len(prefix):].split(':')))
    return misc


class SeparatorBaseMeta(ABCMeta):
    def __new__(cls, name, bases, attrs, **kwargs):
        if UserList not in bases:
            bases += (UserList,)

        names = []
        fields = attrs['FIELDS']
        for index, field in enumerate(fields):
            if isinstance(field, tuple):
                field, fields[index] = field
            else:
                fields[index] = None

            names.append(field)
        attrs['Node'] = namedtuple('Node', names)
        return super().__new__(cls, name, bases, attrs, **kwargs)


class SeparatorBase(UserList, metaclass=SeparatorBaseMeta):
    SEP = '\t'
    FIELDS = []

    def __init__(self, nodes, comment=None):
        super().__init__(nodes)

        self.comment = comment

    @classmethod
    def build_node(cls, line):
        fields = line.strip().split('\t')
        if callable(cls.FIELDS):
            fields = cls.FIELDS(fields)
        elif isinstance(cls.FIELDS, (list, tuple)):
            for index, field_fn in enumerate(cls.FIELDS):
                if isinstance(field_fn, str):
                    field_fn = getattr(cls, field_fn)
                if callable(field_fn):
                    fields[index] = field_fn(fields[index])
        return cls.Node(*fields)

    @classmethod
    def from_string(cls, string):
        lines = string.strip().split('\n')
        assert lines[0].startswith('#')
        comment = lines[0][1:]

        return cls(map(cls.build_node, lines[1:]), comment=comment)


class ConlluSentence(SeparatorBase):
    FIELDS = [('index', int), 'word', 'lemma', 'cpostag', 'postag',
              'feats', ('head', int), 'deprel', 'deps', ('misc', maybe_to_span)]
