/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import java.util.ArrayList;
import java.util.Collections;
import simplenlg.exception.SimplenlgException;
import simplenlg.features.Agreement;
import simplenlg.features.Case;
import simplenlg.features.Category;
import simplenlg.features.DiscourseFunction;
import simplenlg.features.Gender;
import simplenlg.features.NumberAgr;
import simplenlg.features.Person;
import simplenlg.features.Quantification;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.lexicon.lexicalitems.Determiner;
import simplenlg.lexicon.lexicalitems.Noun;
import simplenlg.lexicon.lexicalitems.Preposition;
import simplenlg.lexicon.lexicalitems.Pronoun;
import simplenlg.realiser.AdjPhraseSpec;
import simplenlg.realiser.CoordinateNPPhraseSpec;
import simplenlg.realiser.HeadedPhraseSpec;
import simplenlg.realiser.PPPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.PhraseSpec;
import simplenlg.realiser.Realiser;
import simplenlg.realiser.RefNPPhraseSpec;
import simplenlg.realiser.SPhraseSpec;
import simplenlg.realiser.comparators.PhraseComparator;

public class NPPhraseSpec
extends HeadedPhraseSpec<Noun> {
    Person person;
    NumberAgr number;
    Gender gender;
    Case cs;
    Quantification quant = null;
    boolean elideSpecifier = false;
    Object specifier = new Determiner("");
    Pronoun pronoun;
    String pronounForm;
    boolean treatAsPlural = false;
    boolean pronominal = false;
    boolean possessive = false;
    boolean raised = false;
    boolean isAcronym = false;

    public NPPhraseSpec() {
        this.category = Category.NOUN;
        this.function = DiscourseFunction.NULL;
        this.number = NumberAgr.SINGULAR;
        this.person = Person.THIRD;
        this.gender = Gender.NEUTER;
        this.cs = Case.NOMINATIVE;
        this.pronoun = null;
        this.specifier = null;
        this.premodifierComparator = PhraseComparator.defaultInstance();
    }

    public NPPhraseSpec(String noun) {
        this();
        this.setHead(noun);
    }

    public NPPhraseSpec(String spec, String noun) {
        this(noun);
        if (!this.setSpecifier(spec)) {
            throw new SimplenlgException("Cannot set the specifier supplied to constructor.");
        }
    }

    public NPPhraseSpec(Object spec, Noun noun) {
        this();
        this.setHead(noun);
        if (!this.setSpecifier(spec)) {
            throw new SimplenlgException("Cannot set the specifier supplied to constructor.");
        }
    }

    public NPPhraseSpec(Noun noun) {
        this();
        this.setHead(noun);
    }

    @Override
    public void addModifier(Object mod) {
        if (mod instanceof AdjPhraseSpec) {
            this.addPremodifier(mod);
        } else if (mod instanceof PPPhraseSpec) {
            this.addPostmodifier(mod);
        } else if (mod instanceof NPPhraseSpec || mod instanceof Pronoun) {
            this.addPremodifier(mod);
        } else {
            super.addModifier(mod);
        }
    }

    public void addRelativeClause(SPhraseSpec s) {
        this.addModifier(s);
    }

    public void addRelativeClause(SPhraseSpec s, DiscourseFunction d) {
        this.addRelativeClause(s, d, Constants.PRO_REL);
    }

    public void addRelativeClause(SPhraseSpec s, DiscourseFunction d, Pronoun p) {
        RefNPPhraseSpec np = new RefNPPhraseSpec(this, p);
        s.setComplementiser((NPPhraseSpec)np, d);
        this.addAttributivePostmodifier(s);
    }

    public void addRelativeClause(SPhraseSpec s, Preposition p) {
        this.addRelativeClause(s, p, Constants.PRO_REL);
    }

    public void addRelativeClause(SPhraseSpec s, Preposition p, Pronoun pn) {
        RefNPPhraseSpec np = new RefNPPhraseSpec(this, pn);
        PPPhraseSpec pro = new PPPhraseSpec(p, (Phrase)np);
        s.setComplementiser(pro);
        this.addAttributivePostmodifier(s);
    }

    public void addAttributiveRelativeClause(SPhraseSpec s, NPPhraseSpec np) {
        RefNPPhraseSpec rnp = new RefNPPhraseSpec(this, Constants.PRO_REL);
        np.setSpecifier(rnp);
        s.setComplementiser(np, DiscourseFunction.SUBJECT);
        this.addAttributivePostmodifier(s);
    }

    public boolean setSpecifier(Object spec) {
        if (spec == null) {
            this.specifier = spec;
            return true;
        }
        if (spec instanceof String) {
            this.specifier = Constants.getDeterminer((String)spec);
            if (this.specifier != null) {
                return true;
            }
            if (this.specifier != null) {
                return true;
            }
        } else {
            if (spec instanceof Determiner) {
                this.specifier = spec;
                return true;
            }
            if (spec instanceof Pronoun) {
                this.specifier = spec;
                return true;
            }
        }
        try {
            this.specifier = this.makeConstituent(spec, null);
            return true;
        }
        catch (SimplenlgException se) {
            return false;
        }
    }

    public void setDeterminer(Object spec) {
        this.setSpecifier(spec);
    }

    public Object getSpecifier() {
        return this.specifier;
    }

    public boolean hasSpecifier() {
        return this.specifier != null;
    }

    @Override
    public void setHead(String n) {
        Pronoun p = Constants.getPronoun(n);
        if (p != null) {
            this.setHead(p);
            this.number = Constants.getPronounNumber(n);
        } else {
            this.setHead(new Noun(n));
        }
    }

    @Override
    public void setHead(Noun n) {
        if (n instanceof Pronoun) {
            this.setPronoun((Pronoun)n);
            this.setPerson(((Pronoun)n).getPerson());
            this.pronominal = true;
        } else {
            this.head = n;
            this.setPerson(Person.THIRD);
        }
        this.setGender(n.getGender());
        Agreement agr = n.getAgreement();
        if (agr != null && agr == Agreement.FIXED_PLUR) {
            this.setPlural(true);
        }
    }

    public void setPlural(boolean plur) {
        this.number = plur ? NumberAgr.PLURAL : NumberAgr.SINGULAR;
    }

    public void setNumber(NumberAgr num) {
        this.number = num;
    }

    public NumberAgr getNumber() {
        return this.number;
    }

    public void setPerson(Person p) {
        this.person = p;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setGender(Gender g) {
        this.gender = g;
    }

    public Gender getGender() {
        return this.gender;
    }

    public Case getCase() {
        return this.cs;
    }

    public void setCase(Case cs) {
        this.cs = cs;
    }

    public boolean isDefinite() {
        return this.quant == Quantification.DEFINITE;
    }

    public Quantification getQuantification() {
        return this.quant;
    }

    public void setQuantification(Quantification q) {
        this.quant = q;
        if (!this.hasSpecifier()) {
            if (q == Quantification.DEFINITE) {
                this.setDeterminer(Constants.getDeterminer(true));
            } else if (q == Quantification.INDEFINITE) {
                this.setDeterminer(Constants.getDeterminer(false));
            }
        }
    }

    public void setPronoun(String pro) {
        this.pronoun = Constants.getPronoun(pro);
        if (this.pronoun == null) {
            this.pronoun = new Pronoun(pro);
        }
    }

    public void setPronoun(Pronoun pro) {
        this.pronoun = pro;
    }

    public Pronoun getPronoun() {
        if (this.pronoun != null) {
            return this.pronoun;
        }
        if (this.possessive) {
            return Constants.getPossessivePronoun(this.person, this.number, this.gender);
        }
        return Constants.getPersonalPronoun(this.person);
    }

    public String getPronounAsString() {
        return this.getPronoun().getBaseForm();
    }

    public void setPronominal(boolean pro) {
        this.pronominal = pro;
    }

    public boolean isPronominal() {
        return this.pronominal;
    }

    public boolean isPlural() {
        return this.number.equals(NumberAgr.PLURAL) || this.treatAsPlural;
    }

    public boolean isElideSpecifier() {
        return this.elideSpecifier;
    }

    public void setElideSpecifier(boolean elideSpecifier) {
        this.elideSpecifier = elideSpecifier;
    }

    public void setIsAcronym(boolean name) {
        this.isAcronym = name;
    }

    public boolean isAcronym() {
        return this.isAcronym;
    }

    public void setTreatAsPlural(boolean treatAsPlural) {
        this.treatAsPlural = treatAsPlural;
    }

    public void setPossessive(boolean poss) {
        this.possessive = poss;
    }

    public boolean isPossessive() {
        return this.possessive;
    }

    public boolean isExpletive() {
        if (this.pronominal && this.pronoun != null) {
            return this.getPronoun().isExpletive();
        }
        return false;
    }

    public NPPhraseSpec coordinate(Phrase ... coords) {
        if (coords.length == 0) {
            return this;
        }
        CoordinateNPPhraseSpec coord = new CoordinateNPPhraseSpec(new NPPhraseSpec[]{this});
        try {
            for (Phrase p : coords) {
                coord.addCoordinates((NPPhraseSpec)p);
            }
            return coord;
        }
        catch (ClassCastException cce) {
            throw new SimplenlgException("Cannot coordinate: only phrases of the same type can be coordinated");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof NPPhraseSpec && super.equals(o)) {
            NPPhraseSpec np = (NPPhraseSpec)o;
            if (np.hasSpecifier()) {
                if (this.hasSpecifier()) {
                    return np.specifier.equals(this.specifier);
                }
                return false;
            }
            return !this.hasSpecifier();
        }
        return false;
    }

    @Override
    String realise(Realiser r) {
        this.computeModifierAgreement();
        this.computeArgumentCase();
        this.checkPluralDetFeatures();
        if (this.elided) {
            return "";
        }
        Case c = this.cs;
        String realisation = super.realise(r);
        String negation = this.negated ? "nicht" : "";
        this.cs = c;
        realisation = r.appendSpace(negation, this.realiseSpec(r, realisation), realisation);
        return this.possessive ? realisation + "'s" : realisation;
    }

    String realiseSpec(Realiser r, String agreementString) {
        if (this.specifier == null || this.elideSpecifier || this.pronominal) {
            return "";
        }
        if (this.specifier instanceof Determiner) {
            return ((Determiner)this.specifier).getForm(this.cs, this.number, this.gender);
        }
        if (this.specifier instanceof Pronoun) {
            return ((Pronoun)this.specifier).getSpecifierForm(this.cs, this.number, this.gender);
        }
        return ((PhraseSpec)this.specifier).realise(r);
    }

    @Override
    String realiseHead(Realiser r) {
        if (this.pronominal) {
            return this.realisePronominalHead(r);
        }
        if (this.head == null || ((Noun)this.head).getBaseForm() == null || ((Noun)this.head).getBaseForm().length() == 0) {
            if (this.pronoun == null || this.pronoun.getBaseForm() == null || this.pronoun.getBaseForm().length() == 0) {
                return "";
            }
            this.pronominal = true;
            return this.realisePronominalHead(r);
        }
        if (((Noun)this.head).isAdjectiveInflection()) {
            AdjPhraseSpec a = new AdjPhraseSpec(((Noun)this.head).getBaseAdjective());
            a.setAgreementNP(this);
            return a.realise(r);
        }
        if (this.head instanceof Pronoun) {
            return ((Pronoun)this.head).getForm(this.cs, this.number, this.gender);
        }
        return ((Noun)this.head).getForm(this.cs, this.number);
    }

    String realisePronominalHead(Realiser r) {
        if (this.pronoun == null) {
            this.pronoun = Constants.PRO_3RD;
        }
        String realisation = this.pronoun.getForm(this.cs, this.number, this.gender);
        if (this.negated) {
            realisation = r.appendSpace("nicht", realisation);
        }
        return realisation;
    }

    @Override
    String realisePremodifier(Realiser r) {
        ArrayList<Phrase> pronominalModifiers = new ArrayList<Phrase>();
        ArrayList<Phrase> adjectiveModifiers = new ArrayList<Phrase>();
        if (this.premodifierComparator != null) {
            Collections.sort(this.premodifiers, this.premodifierComparator);
        }
        for (Phrase p : this.premodifiers) {
            if (p == null) continue;
            if (p instanceof NPPhraseSpec) {
                AdjPhraseSpec adj = new AdjPhraseSpec(((NPPhraseSpec)p).getPronounAsString());
                adj.setAgreementNP(this);
                pronominalModifiers.add(adj);
                continue;
            }
            if (p instanceof AdjPhraseSpec) {
                adjectiveModifiers.add(p);
                continue;
            }
            pronominalModifiers.add(p);
        }
        String pre = r.realiseList(pronominalModifiers);
        return (pre = r.appendSpace(pre, r.realiseConjunctList(adjectiveModifiers, ","))) == null ? "" : pre;
    }

    void setRaised(boolean raise) {
        this.raised = raise;
    }

    @Deprecated
    void checkPronounHeadFeatures() {
    }

    void computeModifierAgreement() {
        for (Phrase p : this.getPremodifiers()) {
            if (p == null) continue;
            if (p instanceof AdjPhraseSpec) {
                ((AdjPhraseSpec)p).setAgreementNP(this);
                if (!this.pronominal) continue;
                p.setElided(true);
                continue;
            }
            if (!(p instanceof NPPhraseSpec) || !this.pronominal) continue;
            p.setElided(true);
        }
    }

    void computeArgumentCase() {
        if (this.specifier instanceof NPPhraseSpec) {
            ((NPPhraseSpec)this.specifier).setCase(Case.GENITIVE);
        }
        for (Phrase p : this.complements) {
            if (!(p != null & p instanceof NPPhraseSpec)) continue;
            ((NPPhraseSpec)p).setCase(Case.GENITIVE);
        }
    }

    @Deprecated
    void checkPluralDetFeatures() {
    }

    void initializeArgs() {
        this.elideSpecifier = false;
        this.possessive = false;
        this.raised = false;
    }
}

