/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.morph;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternActionRule
implements Comparable<PatternActionRule> {
    public static final int EXCEPTION = 0;
    public static final int GENERIC = 1;
    public static final int DEFAULT = 2;
    private Matcher leftHandSide;
    private String leftHandString;
    private int offset;
    private String suffix;
    private Integer type = 0;

    public PatternActionRule(String regex, int truncate, String suff) {
        this.leftHandSide = Pattern.compile(regex, 2).matcher("\\w+");
        this.leftHandString = regex;
        this.offset = truncate;
        this.suffix = suff;
    }

    public PatternActionRule(String regex, int truncate, String suff, int newType) {
        if (newType != 0 && newType != 2 && newType != 1) {
            throw new IllegalArgumentException("Type of PatternActionRule is 0 (Exception), 1 (Generic) or 2 (Default)");
        }
        this.type = newType;
        this.leftHandSide = Pattern.compile(regex, 2).matcher("word");
        this.leftHandString = regex;
        this.offset = truncate;
        this.suffix = suff;
    }

    public void setType(int newType) {
        if (newType != 0 && this.type != 2 && this.type != 1) {
            throw new IllegalArgumentException("Type of PatternActionRule is 0 (Exception), 1 (Generic) or 2 (Default)");
        }
        this.type = newType;
    }

    public int getType() {
        return this.type;
    }

    public String getLeftHandSide() {
        return this.leftHandString;
    }

    public boolean applies(String word) {
        word = word.trim();
        this.leftHandSide = this.leftHandSide.reset(word);
        return this.leftHandSide.find();
    }

    public String fire(String word) {
        word = word.trim();
        return this.truncate(word) + this.suffix;
    }

    public boolean analyse(String word) {
        return this.suffix != "" && word.endsWith(this.suffix);
    }

    @Override
    public int compareTo(PatternActionRule rule) {
        return this.type.compareTo(rule.getType());
    }

    private String truncate(String word) {
        if (this.offset == 0) {
            return word;
        }
        StringBuffer buffer = new StringBuffer(word);
        for (int i = 1; i <= this.offset; ++i) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }
}

