/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import simplenlg.exception.SimplenlgException;
import simplenlg.features.Category;
import simplenlg.features.DiscourseFunction;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.lexicon.lexicalitems.Preposition;
import simplenlg.lexicon.morph.Contraction;
import simplenlg.realiser.CoordinatePPPhraseSpec;
import simplenlg.realiser.HeadedPhraseSpec;
import simplenlg.realiser.NPPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.Realiser;

public class PPPhraseSpec
extends HeadedPhraseSpec<Preposition> {
    boolean overrideContractionBehaviour;
    boolean contraction;

    public PPPhraseSpec() {
        this.category = Category.PREPOSITION;
        this.overrideContractionBehaviour = false;
        this.contraction = false;
    }

    public PPPhraseSpec(String preposition) {
        this();
        this.head = new Preposition(preposition);
    }

    public PPPhraseSpec(Preposition prep) {
        this();
        this.head = prep;
    }

    public PPPhraseSpec(String preposition, Object comp) {
        this(preposition);
        this.setComplement(comp);
    }

    public PPPhraseSpec(Preposition prep, Phrase comp) {
        this.head = prep;
        this.setComplement(comp);
    }

    @Override
    public void setHead(String h) {
        this.head = Constants.getPreposition(h);
        if (this.head == null) {
            this.head = new Preposition(h);
        }
    }

    public void setPreposition(String preposition) {
        this.setHead(preposition);
    }

    public boolean isContraction() {
        return this.contraction;
    }

    public void setContraction(boolean contraction) {
        this.overrideContractionBehaviour = true;
        this.contraction = contraction;
    }

    public void resetContraction() {
        this.overrideContractionBehaviour = false;
        this.contraction = true;
    }

    @Override
    public void addComplement(Object comp) {
        Phrase complement = this.makeConstituent(comp, DiscourseFunction.PREP_OBJECT);
        this.complements.add(complement);
    }

    public PPPhraseSpec coordinate(Phrase ... coords) {
        if (coords.length == 0) {
            return this;
        }
        CoordinatePPPhraseSpec coord = new CoordinatePPPhraseSpec(this);
        try {
            for (Phrase p : coords) {
                coord.addCoordinates((PPPhraseSpec)p);
            }
            return coord;
        }
        catch (ClassCastException cce) {
            throw new SimplenlgException("Cannot coordinate: only phrases of the same type can be coordinated");
        }
    }

    @Override
    String realise(Realiser r) {
        this.computeGovernedCase();
        String negText = "";
        if (this.negated) {
            negText = "nicht";
        }
        return r.appendSpace(negText, this.realisePremodifier(r), this.realiseHead(r), this.realiseComplement(r), this.realisePostHead(r), this.realisePostmodifier(r));
    }

    @Override
    String realiseHead(Realiser r) {
        if (((Preposition)this.head).isPostpositional()) {
            return "";
        }
        boolean performContraction = false;
        if (this.complements.get(0) instanceof NPPhraseSpec) {
            NPPhraseSpec np = (NPPhraseSpec)this.complements.get(0);
            if (this.overrideContractionBehaviour) {
                performContraction = this.contraction && Contraction.isPossiblePrepContraction((Preposition)this.head, np);
            } else if (this.complements.size() == 1) {
                performContraction = Contraction.isObligatoryPrepContraction((Preposition)this.head, np);
            }
            if (performContraction) {
                np.setElideSpecifier(true);
                return Contraction.makePrepContraction((Preposition)this.head, np);
            }
        }
        return this.head == null ? "" : ((Preposition)this.head).getLeftForm();
    }

    String realisePostHead(Realiser r) {
        return this.head == null ? "" : ((Preposition)this.head).getRightForm();
    }

    private void computeGovernedCase() {
        for (Phrase p : this.complements) {
            if (!(p instanceof NPPhraseSpec)) continue;
            ((NPPhraseSpec)p).initializeArgs();
            ((NPPhraseSpec)p).setCase(((Preposition)this.head).getGovernedCase());
        }
    }
}

