/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.morph;

import java.util.ArrayList;
import java.util.List;
import simplenlg.features.Form;
import simplenlg.features.NumberAgr;
import simplenlg.features.Person;
import simplenlg.features.Tense;
import simplenlg.features.WordMorph;
import simplenlg.lexicon.lexicalitems.Verb;
import simplenlg.lexicon.morph.VerbInflectionPattern;

public class VerbInflectionPattern {
    String name = "";
    String[] sufPresInd = new String[6];
    String[] sufPastInd = new String[6];
    String[] sufPresSubj = new String[6];
    String[] sufPastSubj = new String[6];
    String[] sufImp = new String[2];
    List<WordMorph> features = new ArrayList<WordMorph>();

    public VerbInflectionPattern() {
    }

    public VerbInflectionPattern(String name, String[] sufPresInd, String[] sufPastInd, String[] sufPresSubj, String[] sufPastSubj, String[] sufImp) {
        this();
        this.name = name;
        this.sufPresInd = sufPresInd;
        this.sufPastInd = sufPastInd;
        this.sufPresSubj = sufPresSubj;
        this.sufPastSubj = sufPastSubj;
        this.sufImp = sufImp;
    }

    public VerbInflectionPattern(String name, String[] sufPresInd, String[] sufPastInd, String[] sufPresSubj, String[] sufPastSubj, String[] sufImp, WordMorph ... featureList) {
        this(name, sufPresInd, sufPastInd, sufPresSubj, sufPastSubj, sufImp);
        for (WordMorph f : featureList) {
            this.features.add(f);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String apply(Verb v, Person p, NumberAgr n, Tense t, Form f) {
        String suffix = this.getSuffix(p, n, t, f);
        if (this.features.contains(WordMorph.FULL_FORMS)) {
            return suffix;
        }
        String stem = this.getStem(v, p, n, t, f);
        return this.addSuffix(stem, suffix);
    }

    private String getStem(Verb v, Person p, NumberAgr n, Tense t, Form f) {
        if (f == Form.IMPERATIVE) {
            return this.getImperativeStem(v, n);
        }
        if (f == Form.SUBJUNCTIVE_II) {
            return v.getSubjunctiveStem();
        }
        switch (1.$SwitchMap$simplenlg$features$Tense[t.ordinal()]) {
            default: {
                if (v.hasAlternatePresentStem() && n == NumberAgr.SINGULAR && f == Form.NORMAL && (p != Person.FIRST || this.features.contains(WordMorph.MODAL_INFLECTION))) {
                    return v.getAlternatePresentStem();
                }
                return v.getPresentStem();
            }
            case 2: 
        }
        if (f == Form.SUBJUNCTIVE || f == Form.SUBJUNCTIVE_II) {
            return v.getSubjunctiveStem();
        }
        return v.getPastStem();
    }

    private String getImperativeStem(Verb v, NumberAgr n) {
        switch (1.$SwitchMap$simplenlg$features$NumberAgr[n.ordinal()]) {
            default: {
                if (this.features.contains(WordMorph.ALTERNATE_IMPERATIVE)) {
                    return v.getAlternatePresentStem();
                }
                return v.getPresentStem();
            }
            case 2: 
        }
        return v.getPresentStem();
    }

    public String getSuffix(Person p, NumberAgr n, Tense t, Form f) {
        return this.getSuffixArray(t, f)[this.getSuffixIndex(p, n, f)];
    }

    private String[] getSuffixArray(Tense t, Form f) {
        switch (1.$SwitchMap$simplenlg$features$Form[f.ordinal()]) {
            default: {
                switch (1.$SwitchMap$simplenlg$features$Tense[t.ordinal()]) {
                    default: {
                        return this.sufPresInd;
                    }
                    case 2: 
                }
                return this.sufPastInd;
            }
            case 2: {
                switch (1.$SwitchMap$simplenlg$features$Tense[t.ordinal()]) {
                    default: {
                        return this.sufPresSubj;
                    }
                    case 2: 
                }
                return this.sufPastSubj;
            }
            case 3: {
                return this.sufPastSubj;
            }
            case 4: 
        }
        return this.sufImp;
    }

    private int getSuffixIndex(Person p, NumberAgr n, Form f) {
        if (f == Form.IMPERATIVE) {
            return n == NumberAgr.SINGULAR ? 0 : 1;
        }
        int base = 0;
        if (n == NumberAgr.PLURAL) {
            base = 3;
        }
        switch (1.$SwitchMap$simplenlg$features$Person[p.ordinal()]) {
            case 1: {
                return base;
            }
            case 2: {
                return base + 1;
            }
        }
        return base + 2;
    }

    private String addSuffix(String base, String suffix) {
        if (suffix.startsWith("s") && base.matches(".*[s\u00dfzx]$")) {
            return base.concat(suffix.substring(1));
        }
        if (suffix.startsWith("e") && base.matches(".*e$")) {
            return base.concat(suffix.substring(1));
        }
        if (suffix.startsWith("e") && this.features.contains(WordMorph.STEM_E_ELISION)) {
            return VerbInflectionPattern.elideFinalE(base).concat(suffix);
        }
        if (suffix.startsWith("t") && base.endsWith("t")) {
            return base.concat(suffix.substring(1));
        }
        return base.concat(suffix);
    }

    private static final String elideFinalE(String base) {
        int i = base.lastIndexOf("e");
        if (i == -1) {
            return base;
        }
        return base.substring(0, i) + base.substring(i + 1);
    }

    public void addFeature(WordMorph feature) {
        this.features.add(feature);
    }

    public VerbInflectionPattern clone(String newName, WordMorph ... features) {
        VerbInflectionPattern newPattern = new VerbInflectionPattern(newName, this.sufPresInd, this.sufPastInd, this.sufPresSubj, this.sufPastSubj, this.sufImp, features);
        return newPattern;
    }

    public VerbInflectionPattern clone(String newName, String[] sufImp) {
        VerbInflectionPattern newPattern = new VerbInflectionPattern(newName, this.sufPresInd, this.sufPastInd, this.sufPresSubj, this.sufPastSubj, sufImp);
        return newPattern;
    }
}

