/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.lexicalitems;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import simplenlg.features.ComplementFrame;
import simplenlg.features.ComplementSlot;
import simplenlg.features.ComplementType;
import simplenlg.lexicon.lexicalitems.ContentWord;
import simplenlg.lexicon.lexicalitems.Word;

public abstract class ContentWord
extends Word {
    List<ComplementFrame> complementationFrames;
    boolean whfin;
    boolean whinf;
    boolean inf;
    boolean binf;
    boolean fin;
    boolean as;
    boolean ed;
    boolean ing;
    boolean np;
    boolean adj;
    boolean adv;
    boolean pp;

    ContentWord() {
        this.inflectionType = null;
        this.complementationFrames = new ArrayList<ComplementFrame>();
    }

    public ContentWord(String baseform) {
        this();
        this.baseForm = baseform;
    }

    public ContentWord(String id, String baseform) {
        this(baseform);
        this.setID(id);
    }

    public ContentWord(String id, String baseform, String citationform) {
        this(id, baseform);
        this.setCitationForm(citationform);
    }

    public Collection<ComplementFrame> getComplementationFrames() {
        return this.complementationFrames;
    }

    public void setComplementationFrames(Collection<ComplementFrame> compFrames) {
        this.complementationFrames.clear();
        for (ComplementFrame frame : compFrames) {
            this.addComplementFrame(frame);
        }
    }

    public boolean hasComplementationFrame() {
        return !this.complementationFrames.isEmpty();
    }

    public void addComplementFrame(ComplementFrame complementFrame) {
        this.complementationFrames.add(complementFrame);
        for (ComplementSlot slot : complementFrame.getComplementSlots()) {
            this.updateFeatures(slot.getType());
        }
    }

    public boolean allowsClauseComp() {
        return this.whfin || this.whinf || this.inf || this.binf || this.fin;
    }

    public boolean allowsWhComp() {
        return this.whfin || this.whinf;
    }

    public boolean allowsFinComp() {
        return this.fin || this.whfin;
    }

    public boolean allowsInfComp() {
        return this.inf || this.binf || this.whinf;
    }

    public boolean allowsBareInfComp() {
        return this.binf;
    }

    public boolean allowsAsComp() {
        return this.as;
    }

    public boolean allowsNPComp() {
        return this.np;
    }

    public boolean allowsAdvComp() {
        return this.adv;
    }

    public boolean allowsAdjComp() {
        return this.adj;
    }

    public boolean allowsPPComp() {
        return this.pp;
    }

    public boolean allowsEdComp() {
        return this.ed;
    }

    public boolean allowsIngComp() {
        return this.ing;
    }

    private void updateFeatures(ComplementType type) {
        switch (1.$SwitchMap$simplenlg$features$ComplementType[type.ordinal()]) {
            case 1: {
                this.inf = true;
                break;
            }
            case 2: {
                this.binf = true;
                break;
            }
            case 3: {
                this.ed = true;
                break;
            }
            case 4: {
                this.ing = true;
                break;
            }
            case 5: {
                this.fin = true;
                break;
            }
            case 6: {
                this.whfin = true;
                break;
            }
            case 7: {
                this.whinf = true;
                break;
            }
            case 8: {
                this.as = true;
                break;
            }
            case 9: {
                this.pp = true;
                break;
            }
            case 10: {
                this.np = true;
                break;
            }
            case 11: {
                this.adj = true;
                break;
            }
            case 12: {
                this.adv = true;
            }
        }
    }
}

