/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.db;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import simplenlg.features.Agreement;
import simplenlg.features.AuxType;
import simplenlg.features.Category;
import simplenlg.features.Gender;
import simplenlg.lexicon.DatabaseBackedLexicon;
import simplenlg.lexicon.lexicalitems.Adjective;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.lexicon.lexicalitems.Noun;
import simplenlg.lexicon.lexicalitems.Verb;
import simplenlg.lexicon.morph.VerbInflectionPattern;

public class XMLHandler
extends DefaultHandler {
    private DatabaseBackedLexicon lexicon;
    private Category cat = null;
    private String catString = null;
    private String id = null;
    private String baseform = null;
    private StringBuffer buffer;
    private String currentCase = null;
    private String currentNumber = null;
    private boolean isRelevantItem = false;
    private String thisId;
    private String stem;
    private String comp;
    private String sup;
    private String past;
    private String part;
    private String altSg;
    private String subj2;
    private String[][] suffixList;
    private String inflection;
    private Gender gender;
    private boolean adjElision;
    private AuxType aux;
    private boolean nounPluraleTantum;
    private boolean nounAdjectiveFlexion;

    XMLHandler() {
        this.resetAllFields();
    }

    XMLHandler(String baseform) {
        this();
        this.baseform = baseform;
    }

    XMLHandler(Category cat, String baseform) {
        this(baseform);
        this.setCat(cat);
    }

    public void setLexicon(DatabaseBackedLexicon lexicon) {
        this.lexicon = lexicon;
    }

    public DatabaseBackedLexicon getLexicon() {
        return this.lexicon;
    }

    public Category getCat() {
        return this.cat;
    }

    public void setCat(Category cat) {
        this.cat = cat;
        this.catString = cat.toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getBaseform() {
        return this.baseform;
    }

    public void setBaseform(String baseform) {
        this.baseform = baseform;
    }

    @Override
    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        if (this.isRelevantItem && this.buffer != null) {
            this.buffer.append(arg0, arg1, arg2);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("noun") || qName.equals("adjective") || qName.equals("verb")) {
            if (this.lookingFor(qName)) {
                this.isRelevantItem = true;
                this.resetAllFields();
                this.readAttributes(atts);
                if (this.id != null && !this.id.equals(this.thisId)) {
                    this.isRelevantItem = false;
                }
            } else {
                this.isRelevantItem = false;
            }
        } else {
            this.buffer = new StringBuffer();
            if (qName.equals("suffix") || qName.equals("form")) {
                this.currentCase = atts.getValue("case");
                this.currentNumber = atts.getValue("num");
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.isRelevantItem) {
            return;
        }
        if (qName.equals("stem")) {
            this.stem = this.buffer.toString();
        } else if (qName.equals("comp")) {
            this.comp = this.buffer.toString();
        } else if (qName.equals("super")) {
            this.sup = this.buffer.toString();
        } else if (qName.equals("past")) {
            this.past = this.buffer.toString();
        } else if (qName.equals("part")) {
            this.part = this.buffer.toString();
        } else if (qName.equals("alt-sg")) {
            this.altSg = this.buffer.toString();
        } else if (qName.equals("subj2")) {
            this.subj2 = this.buffer.toString();
        } else if (qName.equals("suffix") || qName.equals("form")) {
            this.setSuffix(this.currentCase, this.currentNumber, this.buffer.toString());
        } else if (qName.equals("noun") && this.isMatch()) {
            if (this.lexicon != null) {
                this.lexicon.addItem(this.buildNoun());
            }
        } else if (qName.equals("adjective") && this.isMatch()) {
            if (this.lexicon != null) {
                this.lexicon.addItem(this.buildAdjective());
            }
        } else if (qName.equals("verb") && this.isMatch() && this.lexicon != null) {
            this.lexicon.addItem(this.buildVerb());
        }
    }

    private boolean lookingFor(String cat) {
        if (this.cat == null || this.cat == Category.ANY) {
            return true;
        }
        return cat.equalsIgnoreCase(this.catString);
    }

    private boolean isMatch() {
        if (this.id != null && !this.id.equals(this.thisId)) {
            return false;
        }
        return this.baseform == null || this.baseform.equals(this.stem);
    }

    private void readAttributes(Attributes atts) {
        for (int i = 0; i < atts.getLength(); ++i) {
            String attr = atts.getLocalName(i);
            String value = atts.getValue(i);
            this.thisId = null;
            if (attr.equals("elision")) {
                if (value.equalsIgnoreCase("true")) {
                    this.adjElision = true;
                    continue;
                }
                this.adjElision = false;
                continue;
            }
            if (attr.equals("aux")) {
                if (value.equalsIgnoreCase("sein")) {
                    this.aux = AuxType.SEIN;
                    continue;
                }
                if (!value.equalsIgnoreCase("haben")) continue;
                this.aux = AuxType.HABEN;
                continue;
            }
            if (attr.equals("inflection")) {
                this.inflection = value;
                continue;
            }
            if (attr.equals("gender")) {
                if (value.equals("feminine")) {
                    this.gender = Gender.FEMININE;
                    continue;
                }
                if (value.equals("masculine")) {
                    this.gender = Gender.MASCULINE;
                    continue;
                }
                this.gender = Gender.NEUTER;
                continue;
            }
            if (attr.equals("fixedplural")) {
                if (!value.equals("true")) continue;
                this.nounPluraleTantum = true;
                continue;
            }
            if (!attr.equals("adjectiveflexion") || !value.equals("true")) continue;
            this.nounAdjectiveFlexion = true;
        }
    }

    private void resetAllFields() {
        this.thisId = null;
        this.stem = null;
        this.gender = null;
        this.adjElision = false;
        this.aux = null;
        this.inflection = null;
        this.comp = null;
        this.sup = null;
        this.past = "";
        this.part = "";
        this.altSg = "";
        this.subj2 = "";
        this.suffixList = new String[4][2];
        this.nounPluraleTantum = false;
        this.nounAdjectiveFlexion = false;
    }

    private void setSuffix(String cas, String num, String suffix) {
        int arg0 = XMLHandler.getCaseArrayIndex(cas);
        int arg1 = XMLHandler.getNumberArrayIndex(num);
        this.suffixList[arg0][arg1] = suffix;
    }

    private String getSuffix(String cas, String num) {
        int arg0 = XMLHandler.getCaseArrayIndex(cas);
        int arg1 = XMLHandler.getNumberArrayIndex(num);
        return this.suffixList[arg0][arg1];
    }

    private static int getCaseArrayIndex(String cas) {
        if (cas.equalsIgnoreCase("nom")) {
            return 0;
        }
        if (cas.equalsIgnoreCase("acc")) {
            return 1;
        }
        if (cas.equalsIgnoreCase("dat")) {
            return 2;
        }
        if (cas.equalsIgnoreCase("gen")) {
            return 3;
        }
        return -1;
    }

    private static int getNumberArrayIndex(String num) {
        if (num.equalsIgnoreCase("sg")) {
            return 0;
        }
        if (num.equalsIgnoreCase("pl")) {
            return 1;
        }
        return -1;
    }

    private Noun buildNoun() {
        Noun noun = this.nounAdjectiveFlexion || this.nounPluraleTantum ? new Noun(this.stem, this.gender, "", "") : (this.getSuffix("acc", "sg") == null || this.getSuffix("dat", "sg") == null || this.getSuffix("dat", "pl") == null ? new Noun(this.stem, this.gender, this.getSuffix("gen", "sg"), this.getSuffix("nom", "pl")) : new Noun(this.stem, this.gender, this.getSuffix("acc", "sg"), this.getSuffix("gen", "sg"), this.getSuffix("dat", "sg"), this.getSuffix("nom", "pl"), this.getSuffix("dat", "pl")));
        if (this.nounPluraleTantum) {
            noun.setAgreement(Agreement.FIXED_PLUR);
        }
        if (this.nounAdjectiveFlexion) {
            noun.setAdjectiveInflection(true);
        }
        noun.setID(this.thisId);
        return noun;
    }

    private Adjective buildAdjective() {
        Adjective adjective = new Adjective(this.stem, this.comp, this.sup, this.adjElision);
        adjective.setID(this.thisId);
        return adjective;
    }

    private Verb buildVerb() {
        Verb verb;
        VerbInflectionPattern pattern = Constants.VERB_INFLECTION_DEFAULT;
        if (this.inflection != null) {
            pattern = Constants.getInflectionPatternByName(this.inflection);
        }
        if (this.past.isEmpty() || this.part.isEmpty()) {
            verb = new Verb(this.stem, pattern);
            verb.setAuxType(this.aux);
        } else {
            verb = new Verb(this.stem, this.past, this.part, this.altSg, this.subj2, this.aux, pattern);
        }
        verb.setID(this.thisId);
        return verb;
    }
}

