/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.features;

import simplenlg.features.Case;
import simplenlg.features.Category;
import simplenlg.features.DiscourseFunction;
import simplenlg.features.Feature;
import simplenlg.features.Position;

public enum DiscourseFunction implements Feature
{
    SUBJECT(6.0),
    OBJECT(5.0),
    GENITIVE_OBJECT(5.0),
    INDIRECT_OBJECT(4.0),
    PREDICATIVE_COMPLEMENT(3.5),
    PREP_OBJECT(3.0),
    PREMODIFIER(2.0),
    POSTMODIFIER(2.0),
    FRONT_MODIFIER(2.0),
    MODIFIER(2.0),
    CUE_PHRASE(1.0),
    NULL(-1.0);

    private Double salience;

    private DiscourseFunction(double sal) {
        this.salience = new Double(sal);
    }

    public double getSalience() {
        return this.salience;
    }

    public void setSalience(double sal) {
        this.salience = new Double(sal);
    }

    public DiscourseFunction nextUp() {
        switch (1.$SwitchMap$simplenlg$features$DiscourseFunction[this.ordinal()]) {
            case 1: {
                return SUBJECT;
            }
            case 2: {
                return OBJECT;
            }
        }
        return null;
    }

    public DiscourseFunction nextDown() {
        switch (1.$SwitchMap$simplenlg$features$DiscourseFunction[this.ordinal()]) {
            case 3: {
                return OBJECT;
            }
            case 1: {
                return INDIRECT_OBJECT;
            }
        }
        return null;
    }

    @Override
    public boolean appliesTo(Category cat) {
        return cat.equals((Object)Category.NOUN);
    }

    public int compareSalience(DiscourseFunction f) {
        return -this.salience.compareTo(f.getSalience());
    }

    public Case getCaseValue() {
        switch (1.$SwitchMap$simplenlg$features$DiscourseFunction[this.ordinal()]) {
            default: {
                return Case.NOMINATIVE;
            }
            case 1: 
            case 7: {
                return Case.ACCUSATIVE;
            }
            case 2: {
                return Case.DATIVE;
            }
            case 8: 
        }
        return Case.GENITIVE;
    }

    public Position mapToPosition() {
        switch (1.$SwitchMap$simplenlg$features$DiscourseFunction[this.ordinal()]) {
            case 3: {
                return Position.SUBJECT;
            }
            case 1: {
                return Position.OBJECT;
            }
            case 8: {
                return Position.GENITIVE_OBJECT;
            }
            case 2: {
                return Position.INDIRECT_OBJECT;
            }
            case 4: 
            case 5: {
                return Position.FRONT;
            }
        }
        return Position.DEFAULT;
    }

    public boolean isComplementFunction() {
        return this.equals(SUBJECT) || this.equals(OBJECT) || this.equals(INDIRECT_OBJECT) || this.equals(GENITIVE_OBJECT);
    }
}

